/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.cloud.sleuth;

import brave.Tracer;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceNameResolver;
import com.github.gavlyukovskiy.cloud.sleuth.SleuthProperties;
import com.github.gavlyukovskiy.cloud.sleuth.TracingListenerStrategy;
import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.PreparedStatementInformation;
import com.p6spy.engine.common.ResultSetInformation;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.SimpleJdbcEventListener;
import java.sql.SQLException;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class TracingJdbcEventListener
extends SimpleJdbcEventListener
implements Ordered {
    private final DataSourceNameResolver dataSourceNameResolver;
    private final TracingListenerStrategy<ConnectionInformation, StatementInformation, ResultSetInformation> strategy;
    private final boolean includeParameterValues;

    TracingJdbcEventListener(Tracer tracer, DataSourceNameResolver dataSourceNameResolver, List<SleuthProperties.TraceType> traceTypes, boolean includeParameterValues) {
        this.dataSourceNameResolver = dataSourceNameResolver;
        this.includeParameterValues = includeParameterValues;
        this.strategy = new TracingListenerStrategy(tracer, traceTypes);
    }

    public void onBeforeGetConnection(ConnectionInformation connectionInformation) {
        String dataSourceName = this.dataSourceNameResolver.resolveDataSourceName(connectionInformation.getDataSource());
        this.strategy.beforeGetConnection(connectionInformation, dataSourceName);
    }

    public void onAfterGetConnection(ConnectionInformation connectionInformation, SQLException e) {
        this.strategy.afterGetConnection(connectionInformation, e);
    }

    public void onBeforeAnyExecute(StatementInformation statementInformation) {
        String dataSourceName = this.dataSourceNameResolver.resolveDataSourceName(statementInformation.getConnectionInformation().getDataSource());
        this.strategy.beforeQuery(statementInformation.getConnectionInformation(), statementInformation, dataSourceName);
    }

    public void onAfterAnyExecute(StatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
        this.strategy.afterQuery(statementInformation.getConnectionInformation(), statementInformation, this.getSql(statementInformation), e);
    }

    public void onBeforeResultSetNext(ResultSetInformation resultSetInformation) {
        String dataSourceName = this.dataSourceNameResolver.resolveDataSourceName(resultSetInformation.getConnectionInformation().getDataSource());
        this.strategy.beforeResultSetNext(resultSetInformation.getConnectionInformation(), resultSetInformation.getStatementInformation(), resultSetInformation, dataSourceName);
    }

    public void onAfterExecuteUpdate(PreparedStatementInformation statementInformation, long timeElapsedNanos, int rowCount, SQLException e) {
        if (e == null) {
            this.strategy.addQueryRowCount(statementInformation.getConnectionInformation(), (StatementInformation)statementInformation, rowCount);
        }
        super.onAfterExecuteUpdate(statementInformation, timeElapsedNanos, rowCount, e);
    }

    public void onAfterExecuteUpdate(StatementInformation statementInformation, long timeElapsedNanos, String sql, int rowCount, SQLException e) {
        if (e == null) {
            this.strategy.addQueryRowCount(statementInformation.getConnectionInformation(), statementInformation, rowCount);
        }
        super.onAfterExecuteUpdate(statementInformation, timeElapsedNanos, sql, rowCount, e);
    }

    public void onAfterStatementClose(StatementInformation statementInformation, SQLException e) {
        this.strategy.afterStatementClose(statementInformation.getConnectionInformation(), statementInformation);
    }

    public void onAfterResultSetClose(ResultSetInformation resultSetInformation, SQLException e) {
        this.strategy.afterResultSetClose(resultSetInformation.getConnectionInformation(), resultSetInformation, resultSetInformation.getCurrRow() + 1, e);
    }

    public void onAfterCommit(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        this.strategy.afterCommit(connectionInformation, e);
    }

    public void onAfterRollback(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        this.strategy.afterRollback(connectionInformation, e);
    }

    public void onAfterConnectionClose(ConnectionInformation connectionInformation, SQLException e) {
        this.strategy.afterConnectionClose(connectionInformation, e);
    }

    private String getSql(StatementInformation statementInformation) {
        return this.includeParameterValues && StringUtils.hasText((String)statementInformation.getSqlWithValues()) ? statementInformation.getSqlWithValues() : statementInformation.getSql();
    }

    public int getOrder() {
        return -2147483638;
    }
}

