/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.cloud.sleuth;

import brave.Tracer;
import com.github.gavlyukovskiy.cloud.sleuth.SleuthProperties;
import com.github.gavlyukovskiy.cloud.sleuth.TracingListenerStrategy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionContext;
import net.ttddyy.dsproxy.listener.MethodExecutionListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import org.springframework.core.Ordered;

public class TracingQueryExecutionListener
implements QueryExecutionListener,
MethodExecutionListener,
Ordered {
    private final TracingListenerStrategy<String, Statement, ResultSet> strategy;

    TracingQueryExecutionListener(Tracer tracer, List<SleuthProperties.TraceType> traceTypes) {
        this.strategy = new TracingListenerStrategy(tracer, traceTypes);
    }

    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        this.strategy.beforeQuery(execInfo.getConnectionId(), execInfo.getStatement(), execInfo.getDataSourceName());
    }

    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        if (execInfo.getMethod().getName().equals("executeUpdate") && execInfo.getThrowable() == null) {
            this.strategy.addQueryRowCount(execInfo.getConnectionId(), execInfo.getStatement(), (Integer)execInfo.getResult());
        }
        String sql = queryInfoList.stream().map(QueryInfo::getQuery).collect(Collectors.joining("\n"));
        this.strategy.afterQuery(execInfo.getConnectionId(), execInfo.getStatement(), sql, execInfo.getThrowable());
    }

    public void beforeMethod(MethodExecutionContext executionContext) {
        Object target = executionContext.getTarget();
        String methodName = executionContext.getMethod().getName();
        String dataSourceName = executionContext.getProxyConfig().getDataSourceName();
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        if (target instanceof DataSource) {
            if (methodName.equals("getConnection")) {
                this.strategy.beforeGetConnection(connectionId, dataSourceName);
            }
        } else if (target instanceof ResultSet) {
            ResultSet resultSet = (ResultSet)target;
            if (methodName.equals("next")) {
                try {
                    this.strategy.beforeResultSetNext(connectionId, resultSet.getStatement(), resultSet, dataSourceName);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public void afterMethod(MethodExecutionContext executionContext) {
        Object target = executionContext.getTarget();
        String methodName = executionContext.getMethod().getName();
        String connectionId = executionContext.getConnectionInfo().getConnectionId();
        Throwable t = executionContext.getThrown();
        if (target instanceof DataSource) {
            if (methodName.equals("getConnection")) {
                this.strategy.afterGetConnection(connectionId, t);
            }
        } else if (target instanceof Connection) {
            if (methodName.equals("commit")) {
                this.strategy.afterCommit(connectionId, t);
            } else if (methodName.equals("rollback")) {
                this.strategy.afterRollback(connectionId, t);
            } else if (methodName.equals("close")) {
                this.strategy.afterConnectionClose(connectionId, t);
            }
        } else if (target instanceof Statement) {
            if (methodName.equals("close")) {
                this.strategy.afterStatementClose(connectionId, (Statement)target);
            }
        } else if (target instanceof ResultSet && methodName.equals("close")) {
            ResultSet resultSet = (ResultSet)target;
            this.strategy.afterResultSetClose(connectionId, resultSet, -1, t);
        }
    }

    public int getOrder() {
        return -2147483638;
    }
}

