/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;

public class Function
extends ASTNodeAccessImpl
implements Expression {
    private List<String> nameparts;
    private ExpressionList<?> parameters;
    private NamedExpressionList<?> namedParameters;
    private boolean allColumns = false;
    private boolean distinct = false;
    private boolean unique = false;
    private boolean isEscaped = false;
    private Expression attributeExpression;
    private HavingClause havingClause;
    private Column attributeColumn = null;
    private List<OrderByElement> orderByElements;
    private NullHandling nullHandling = null;
    private boolean ignoreNullsOutside = false;
    private Limit limit = null;
    private KeepExpression keep = null;

    public Function() {
    }

    public Function(String name, Expression ... parameters) {
        this.nameparts = Arrays.asList(name);
        this.parameters = new ExpressionList(parameters);
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public String getName() {
        return this.nameparts == null ? null : String.join((CharSequence)(this.nameparts.get(0).equalsIgnoreCase("APPROXIMATE") ? " " : "."), this.nameparts);
    }

    public void setName(String string) {
        this.nameparts = Arrays.asList(string);
    }

    public void setName(List<String> string) {
        this.nameparts = string;
    }

    public List<String> getMultipartName() {
        return this.nameparts;
    }

    public Function withName(String name) {
        this.setName(name);
        return this;
    }

    public Function withName(List<String> nameparts) {
        this.nameparts = nameparts;
        return this;
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean b) {
        this.allColumns = b;
    }

    public NullHandling getNullHandling() {
        return this.nullHandling;
    }

    public Function setNullHandling(NullHandling nullHandling) {
        this.nullHandling = nullHandling;
        return this;
    }

    public boolean isIgnoreNullsOutside() {
        return this.ignoreNullsOutside;
    }

    public Function setIgnoreNullsOutside(boolean ignoreNullsOutside) {
        this.ignoreNullsOutside = ignoreNullsOutside;
        return this;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public Function setLimit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public boolean isIgnoreNulls() {
        return this.nullHandling != null && this.nullHandling == NullHandling.IGNORE_NULLS;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.nullHandling = ignoreNulls ? NullHandling.IGNORE_NULLS : null;
    }

    public HavingClause getHavingClause() {
        return this.havingClause;
    }

    public Function setHavingClause(HavingClause havingClause) {
        this.havingClause = havingClause;
        return this;
    }

    public Function setHavingClause(String havingType, Expression expression) {
        this.havingClause = new HavingClause(HavingClause.HavingType.valueOf(havingType.trim().toUpperCase()), expression);
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean b) {
        this.unique = b;
    }

    public ExpressionList<?> getParameters() {
        return this.parameters;
    }

    public void setParameters(Expression ... expressions) {
        this.parameters = expressions.length == 1 && expressions[0] instanceof ExpressionList ? (ExpressionList)expressions[0] : new ExpressionList(expressions);
    }

    public void setParameters(ExpressionList<?> list) {
        this.parameters = list;
    }

    public NamedExpressionList<?> getNamedParameters() {
        return this.namedParameters;
    }

    public void setNamedParameters(NamedExpressionList<?> list) {
        this.namedParameters = list;
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public void setEscaped(boolean isEscaped) {
        this.isEscaped = isEscaped;
    }

    public Object getAttribute() {
        return this.attributeExpression != null ? this.attributeExpression : this.attributeColumn;
    }

    public void setAttribute(Expression attributeExpression) {
        this.attributeExpression = attributeExpression;
    }

    public void setAttribute(Column attributeColumn) {
        this.attributeExpression = null;
        this.attributeColumn = attributeColumn;
    }

    @Deprecated
    public String getAttributeName() {
        return this.attributeColumn.toString();
    }

    public void setAttributeName(String attributeName) {
        this.attributeColumn = new Column().withColumnName(attributeName);
    }

    public Column getAttributeColumn() {
        return this.attributeColumn;
    }

    public Function withAttribute(Column attributeColumn) {
        this.setAttribute(attributeColumn);
        return this;
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keep) {
        this.keep = keep;
    }

    public String toString() {
        String params;
        if (this.parameters != null || this.namedParameters != null) {
            if (this.parameters != null) {
                StringBuilder b = new StringBuilder();
                b.append("(");
                if (this.isDistinct()) {
                    b.append("DISTINCT ");
                } else if (this.isUnique()) {
                    b.append("UNIQUE ");
                }
                if (this.isAllColumns()) {
                    b.append("ALL ");
                }
                b.append(this.parameters);
                if (this.havingClause != null) {
                    this.havingClause.appendTo(b);
                }
                if (this.nullHandling != null && !this.isIgnoreNullsOutside()) {
                    switch (this.nullHandling) {
                        case IGNORE_NULLS: {
                            b.append(" IGNORE NULLS");
                            break;
                        }
                        case RESPECT_NULLS: {
                            b.append(" RESPECT NULLS");
                        }
                    }
                }
                if (this.orderByElements != null) {
                    b.append(" ORDER BY ");
                    boolean comma = false;
                    for (OrderByElement orderByElement : this.orderByElements) {
                        if (comma) {
                            b.append(", ");
                        } else {
                            comma = true;
                        }
                        b.append(orderByElement);
                    }
                }
                if (this.limit != null) {
                    b.append(this.limit);
                }
                b.append(")");
                params = b.toString();
            } else {
                params = this.namedParameters.toString();
            }
        } else {
            params = "()";
        }
        String ans = this.getName() + params;
        if (this.nullHandling != null && this.isIgnoreNullsOutside()) {
            switch (this.nullHandling) {
                case IGNORE_NULLS: {
                    ans = ans + " IGNORE NULLS";
                    break;
                }
                case RESPECT_NULLS: {
                    ans = ans + " RESPECT NULLS";
                }
            }
        }
        if (this.attributeExpression != null) {
            ans = ans + "." + this.attributeExpression;
        } else if (this.attributeColumn != null) {
            ans = ans + "." + this.attributeColumn;
        }
        if (this.keep != null) {
            ans = ans + " " + this.keep;
        }
        if (this.isEscaped) {
            ans = "{fn " + ans + "}";
        }
        return ans;
    }

    public Function withAttribute(Expression attribute) {
        this.setAttribute(attribute);
        return this;
    }

    @Deprecated
    public Function withAttributeName(String attributeName) {
        this.setAttributeName(attributeName);
        return this;
    }

    public Function withKeep(KeepExpression keep) {
        this.setKeep(keep);
        return this;
    }

    public Function withIgnoreNulls(boolean ignoreNulls) {
        this.setIgnoreNulls(ignoreNulls);
        return this;
    }

    public Function withParameters(ExpressionList<?> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public Function withParameters(Expression ... parameters) {
        return this.withParameters(new ExpressionList(parameters));
    }

    public Function withNamedParameters(NamedExpressionList<?> namedParameters) {
        this.setNamedParameters(namedParameters);
        return this;
    }

    public Function withAllColumns(boolean allColumns) {
        this.setAllColumns(allColumns);
        return this;
    }

    public Function withDistinct(boolean distinct) {
        this.setDistinct(distinct);
        return this;
    }

    public Function withUnique(boolean unique) {
        this.setUnique(unique);
        return this;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public <E extends Expression> E getAttribute(Class<E> type) {
        return (E)((Expression)type.cast(this.getAttribute()));
    }

    public static class HavingClause
    extends ASTNodeAccessImpl
    implements Expression {
        HavingType havingType;
        Expression expression;

        public HavingClause(HavingType havingType, Expression expression) {
            this.havingType = havingType;
            this.expression = expression;
        }

        public HavingType getHavingType() {
            return this.havingType;
        }

        public HavingClause setHavingType(HavingType havingType) {
            this.havingType = havingType;
            return this;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public HavingClause setExpression(Expression expression) {
            this.expression = expression;
            return this;
        }

        @Override
        public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
            return this.expression.accept(expressionVisitor, context);
        }

        @Override
        public StringBuilder appendTo(StringBuilder builder) {
            builder.append(" HAVING ").append(this.havingType.name()).append(" ").append(this.expression);
            return builder;
        }

        public String toString() {
            return this.appendTo(new StringBuilder()).toString();
        }

        static enum HavingType {
            MAX,
            MIN;

        }
    }

    public static enum NullHandling {
        IGNORE_NULLS,
        RESPECT_NULLS;

    }
}

