/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar;

import com.github.junrar.UnrarCallback;
import com.github.junrar.Volume;
import com.github.junrar.VolumeManager;
import com.github.junrar.exception.RarException;
import com.github.junrar.impl.FileVolumeManager;
import com.github.junrar.impl.InputStreamVolumeManager;
import com.github.junrar.io.IReadOnlyAccess;
import com.github.junrar.rarfile.AVHeader;
import com.github.junrar.rarfile.BaseBlock;
import com.github.junrar.rarfile.BlockHeader;
import com.github.junrar.rarfile.CommentHeader;
import com.github.junrar.rarfile.EAHeader;
import com.github.junrar.rarfile.EndArcHeader;
import com.github.junrar.rarfile.FileHeader;
import com.github.junrar.rarfile.MacInfoHeader;
import com.github.junrar.rarfile.MainHeader;
import com.github.junrar.rarfile.MarkHeader;
import com.github.junrar.rarfile.ProtectHeader;
import com.github.junrar.rarfile.RARVersion;
import com.github.junrar.rarfile.SignHeader;
import com.github.junrar.rarfile.SubBlockHeader;
import com.github.junrar.rarfile.UnixOwnersHeader;
import com.github.junrar.rarfile.UnrarHeadertype;
import com.github.junrar.unpack.ComprDataIO;
import com.github.junrar.unpack.Unpack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Archive
implements Closeable,
Iterable<FileHeader> {
    private static final Log logger = LogFactory.getLog(Archive.class);
    private static int MAX_HEADER_SIZE = 0x1400000;
    private IReadOnlyAccess rof;
    private final UnrarCallback unrarCallback;
    private final ComprDataIO dataIO;
    private final List<BaseBlock> headers = new ArrayList<BaseBlock>();
    private MarkHeader markHead = null;
    private MainHeader newMhd = null;
    private Unpack unpack;
    private int currentHeaderIndex;
    private long totalPackedSize = 0L;
    private long totalPackedRead = 0L;
    private VolumeManager volumeManager;
    private Volume volume;
    private FileHeader nextFileHeader;

    public Archive(VolumeManager volumeManager) throws RarException, IOException {
        this(volumeManager, null);
    }

    public Archive(VolumeManager volumeManager, UnrarCallback unrarCallback) throws RarException, IOException {
        this.volumeManager = volumeManager;
        this.unrarCallback = unrarCallback;
        try {
            this.setVolume(this.volumeManager.nextArchive(this, null));
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                logger.error((Object)"Failed to close the archive after an internal error!");
            }
            throw e;
        }
        catch (RarException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                logger.error((Object)"Failed to close the archive after an internal error!");
            }
            throw e;
        }
        this.dataIO = new ComprDataIO(this);
    }

    public Archive(File firstVolume, UnrarCallback unrarCallback) throws RarException, IOException {
        this(new FileVolumeManager(firstVolume), unrarCallback);
    }

    public Archive(InputStream rarAsStream) throws RarException, IOException {
        this(new InputStreamVolumeManager(rarAsStream), null);
    }

    private void setFile(IReadOnlyAccess file, long length) throws IOException, RarException {
        block4: {
            this.totalPackedSize = 0L;
            this.totalPackedRead = 0L;
            this.close();
            this.rof = file;
            try {
                this.readHeaders(length);
            }
            catch (Exception e) {
                logger.warn((Object)"exception in archive constructor maybe file is encrypted, corrupt or support not yet implemented", (Throwable)e);
                if (!(e instanceof RarException) || ((RarException)e).getType() != RarException.RarExceptionType.unsupportedRarArchive) break block4;
                throw (RarException)e;
            }
        }
        for (BaseBlock block : this.headers) {
            if (block.getHeaderType() != UnrarHeadertype.FileHeader) continue;
            this.totalPackedSize += ((FileHeader)block).getFullPackSize();
        }
        if (this.unrarCallback != null) {
            this.unrarCallback.volumeProgressChanged(this.totalPackedRead, this.totalPackedSize);
        }
    }

    public void bytesReadRead(int count) {
        if (count > 0) {
            this.totalPackedRead += (long)count;
            if (this.unrarCallback != null) {
                this.unrarCallback.volumeProgressChanged(this.totalPackedRead, this.totalPackedSize);
            }
        }
    }

    public IReadOnlyAccess getRof() {
        return this.rof;
    }

    public List<BaseBlock> getHeaders() {
        return new ArrayList<BaseBlock>(this.headers);
    }

    public List<FileHeader> getFileHeaders() {
        ArrayList<FileHeader> list = new ArrayList<FileHeader>();
        for (BaseBlock block : this.headers) {
            if (!block.getHeaderType().equals((Object)UnrarHeadertype.FileHeader)) continue;
            list.add((FileHeader)block);
        }
        return list;
    }

    public FileHeader nextFileHeader() {
        int n = this.headers.size();
        while (this.currentHeaderIndex < n) {
            BaseBlock block;
            if ((block = this.headers.get(this.currentHeaderIndex++)).getHeaderType() != UnrarHeadertype.FileHeader) continue;
            return (FileHeader)block;
        }
        return null;
    }

    public UnrarCallback getUnrarCallback() {
        return this.unrarCallback;
    }

    public boolean isEncrypted() throws RarException {
        if (this.newMhd != null) {
            return this.newMhd.isEncrypted();
        }
        throw new RarException(RarException.RarExceptionType.mainHeaderNull);
    }

    private void readHeaders(long fileLength) throws IOException, RarException {
        block31: {
            this.markHead = null;
            this.newMhd = null;
            this.headers.clear();
            this.currentHeaderIndex = 0;
            int toRead = 0;
            HashSet<Long> processedPositions = new HashSet<Long>();
            block21: while (true) {
                int size = 0;
                long newpos = 0L;
                byte[] baseBlockBuffer = Archive.safelyAllocate(7L, MAX_HEADER_SIZE);
                long position = this.rof.getPosition();
                if (position >= fileLength || (size = this.rof.readFully(baseBlockBuffer, 7)) == 0) break block31;
                BaseBlock block = new BaseBlock(baseBlockBuffer);
                block.setPositionInFile(position);
                switch (block.getHeaderType()) {
                    case MarkHeader: {
                        this.markHead = new MarkHeader(block);
                        if (!this.markHead.isSignature()) {
                            if (this.markHead.getVersion() == RARVersion.V5) {
                                logger.warn((Object)"Support for rar version 5 is not yet implemented!");
                                throw new RarException(RarException.RarExceptionType.unsupportedRarArchive);
                            }
                            throw new RarException(RarException.RarExceptionType.badRarArchive);
                        }
                        this.headers.add(this.markHead);
                        continue block21;
                    }
                    case MainHeader: {
                        toRead = block.hasEncryptVersion() ? 7 : 6;
                        byte[] mainbuff = Archive.safelyAllocate(toRead, MAX_HEADER_SIZE);
                        this.rof.readFully(mainbuff, toRead);
                        MainHeader mainhead = new MainHeader(block, mainbuff);
                        this.headers.add(mainhead);
                        this.newMhd = mainhead;
                        if (!this.newMhd.isEncrypted()) continue block21;
                        throw new RarException(RarException.RarExceptionType.rarEncryptedException);
                    }
                    case SignHeader: {
                        toRead = 8;
                        byte[] signBuff = Archive.safelyAllocate(toRead, MAX_HEADER_SIZE);
                        this.rof.readFully(signBuff, toRead);
                        SignHeader signHead = new SignHeader(block, signBuff);
                        this.headers.add(signHead);
                        continue block21;
                    }
                    case AvHeader: {
                        toRead = 7;
                        byte[] avBuff = Archive.safelyAllocate(toRead, MAX_HEADER_SIZE);
                        this.rof.readFully(avBuff, toRead);
                        AVHeader avHead = new AVHeader(block, avBuff);
                        this.headers.add(avHead);
                        continue block21;
                    }
                    case CommHeader: {
                        toRead = 6;
                        byte[] commBuff = Archive.safelyAllocate(toRead, MAX_HEADER_SIZE);
                        this.rof.readFully(commBuff, toRead);
                        CommentHeader commHead = new CommentHeader(block, commBuff);
                        this.headers.add(commHead);
                        newpos = commHead.getPositionInFile() + (long)commHead.getHeaderSize();
                        if (processedPositions.contains(newpos)) {
                            throw new RarException(RarException.RarExceptionType.badRarArchive);
                        }
                        processedPositions.add(newpos);
                        this.rof.setPosition(newpos);
                        continue block21;
                    }
                    case EndArcHeader: {
                        EndArcHeader endArcHead;
                        toRead = 0;
                        if (block.hasArchiveDataCRC()) {
                            toRead += 4;
                        }
                        if (block.hasVolumeNumber()) {
                            toRead += 2;
                        }
                        if (toRead > 0) {
                            byte[] endArchBuff = Archive.safelyAllocate(toRead, MAX_HEADER_SIZE);
                            this.rof.readFully(endArchBuff, toRead);
                            endArcHead = new EndArcHeader(block, endArchBuff);
                        } else {
                            endArcHead = new EndArcHeader(block, null);
                        }
                        this.headers.add(endArcHead);
                        return;
                    }
                }
                byte[] blockHeaderBuffer = Archive.safelyAllocate(4L, MAX_HEADER_SIZE);
                this.rof.readFully(blockHeaderBuffer, 4);
                BlockHeader blockHead = new BlockHeader(block, blockHeaderBuffer);
                switch (blockHead.getHeaderType()) {
                    case NewSubHeader: 
                    case FileHeader: {
                        toRead = blockHead.getHeaderSize() - 7 - 4;
                        byte[] fileHeaderBuffer = Archive.safelyAllocate(toRead, MAX_HEADER_SIZE);
                        this.rof.readFully(fileHeaderBuffer, toRead);
                        FileHeader fh = new FileHeader(blockHead, fileHeaderBuffer);
                        this.headers.add(fh);
                        newpos = fh.getPositionInFile() + (long)fh.getHeaderSize() + fh.getFullPackSize();
                        if (processedPositions.contains(newpos)) {
                            throw new RarException(RarException.RarExceptionType.badRarArchive);
                        }
                        processedPositions.add(newpos);
                        this.rof.setPosition(newpos);
                        continue block21;
                    }
                    case ProtectHeader: {
                        toRead = blockHead.getHeaderSize() - 7 - 4;
                        byte[] protectHeaderBuffer = Archive.safelyAllocate(toRead, MAX_HEADER_SIZE);
                        this.rof.readFully(protectHeaderBuffer, toRead);
                        ProtectHeader ph = new ProtectHeader(blockHead, protectHeaderBuffer);
                        newpos = ph.getPositionInFile() + (long)ph.getHeaderSize() + ph.getDataSize();
                        if (processedPositions.contains(newpos)) {
                            throw new RarException(RarException.RarExceptionType.badRarArchive);
                        }
                        processedPositions.add(newpos);
                        this.rof.setPosition(newpos);
                        continue block21;
                    }
                    case SubHeader: {
                        byte[] subHeadbuffer = Archive.safelyAllocate(3L, MAX_HEADER_SIZE);
                        this.rof.readFully(subHeadbuffer, 3);
                        SubBlockHeader subHead = new SubBlockHeader(blockHead, subHeadbuffer);
                        subHead.print();
                        switch (subHead.getSubType()) {
                            case MAC_HEAD: {
                                byte[] macHeaderbuffer = Archive.safelyAllocate(8L, MAX_HEADER_SIZE);
                                this.rof.readFully(macHeaderbuffer, 8);
                                MacInfoHeader macHeader = new MacInfoHeader(subHead, macHeaderbuffer);
                                macHeader.print();
                                this.headers.add(macHeader);
                                continue block21;
                            }
                            case BEEA_HEAD: {
                                continue block21;
                            }
                            case EA_HEAD: {
                                byte[] eaHeaderBuffer = Archive.safelyAllocate(10L, MAX_HEADER_SIZE);
                                this.rof.readFully(eaHeaderBuffer, 10);
                                EAHeader eaHeader = new EAHeader(subHead, eaHeaderBuffer);
                                eaHeader.print();
                                this.headers.add(eaHeader);
                                continue block21;
                            }
                            case NTACL_HEAD: {
                                continue block21;
                            }
                            case STREAM_HEAD: {
                                continue block21;
                            }
                            case UO_HEAD: {
                                toRead = subHead.getHeaderSize();
                                toRead -= 7;
                                toRead -= 4;
                                byte[] uoHeaderBuffer = Archive.safelyAllocate(toRead -= 3, MAX_HEADER_SIZE);
                                this.rof.readFully(uoHeaderBuffer, toRead);
                                UnixOwnersHeader uoHeader = new UnixOwnersHeader(subHead, uoHeaderBuffer);
                                uoHeader.print();
                                this.headers.add(uoHeader);
                                continue block21;
                            }
                        }
                        continue block21;
                    }
                }
                break;
            }
            logger.warn((Object)"Unknown Header");
            throw new RarException(RarException.RarExceptionType.notRarArchive);
        }
    }

    private static byte[] safelyAllocate(long len, int maxSize) throws RarException {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxsize must be >= 0");
        }
        if (len < 0L || len > (long)maxSize) {
            throw new RarException(RarException.RarExceptionType.badRarArchive);
        }
        return new byte[(int)len];
    }

    public void extractFile(FileHeader hd, OutputStream os) throws RarException {
        if (!this.headers.contains(hd)) {
            throw new RarException(RarException.RarExceptionType.headerNotInArchive);
        }
        try {
            this.doExtractFile(hd, os);
        }
        catch (Exception e) {
            if (e instanceof RarException) {
                throw (RarException)e;
            }
            throw new RarException(e);
        }
    }

    public InputStream getInputStream(FileHeader hd) throws RarException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.extractFile(hd, out);
        }
        catch (RarException e) {
            throw new RarException(e, RarException.RarExceptionType.ioError);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new RarException(e, RarException.RarExceptionType.ioError);
            }
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    private void doExtractFile(FileHeader hd, OutputStream os) throws RarException, IOException {
        this.dataIO.init(os);
        this.dataIO.init(hd);
        this.dataIO.setUnpFileCRC(this.isOldFormat() ? 0L : -1L);
        if (this.unpack == null) {
            this.unpack = new Unpack(this.dataIO);
        }
        if (!hd.isSolid()) {
            this.unpack.init(null);
        }
        this.unpack.setDestSize(hd.getFullUnpackSize());
        try {
            this.unpack.doUnpack(hd.getUnpVersion(), hd.isSolid());
            hd = this.dataIO.getSubHeader();
            long actualCRC = hd.isSplitAfter() ? this.dataIO.getPackedCRC() ^ 0xFFFFFFFFFFFFFFFFL : this.dataIO.getUnpFileCRC() ^ 0xFFFFFFFFFFFFFFFFL;
            int expectedCRC = hd.getFileCRC();
            if (actualCRC != (long)expectedCRC) {
                throw new RarException(RarException.RarExceptionType.crcError);
            }
        }
        catch (Exception e) {
            this.unpack.cleanUp();
            if (e instanceof RarException) {
                throw (RarException)e;
            }
            throw new RarException(e);
        }
    }

    public MainHeader getMainHeader() {
        return this.newMhd;
    }

    public boolean isOldFormat() {
        return this.markHead.isOldFormat();
    }

    @Override
    public void close() throws IOException {
        if (this.rof != null) {
            this.rof.close();
            this.rof = null;
        }
        if (this.unpack != null) {
            this.unpack.cleanUp();
        }
    }

    public VolumeManager getVolumeManager() {
        return this.volumeManager;
    }

    public void setVolumeManager(VolumeManager volumeManager) {
        this.volumeManager = volumeManager;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public void setVolume(Volume volume) throws IOException, RarException {
        this.volume = volume;
        this.setFile(volume.getReadOnlyAccess(), volume.getLength());
    }

    @Override
    public Iterator<FileHeader> iterator() {
        return new Iterator<FileHeader>(){

            @Override
            public FileHeader next() {
                FileHeader next = Archive.this.nextFileHeader != null ? Archive.this.nextFileHeader : Archive.this.nextFileHeader();
                return next;
            }

            @Override
            public boolean hasNext() {
                Archive.this.nextFileHeader = Archive.this.nextFileHeader();
                return Archive.this.nextFileHeader != null;
            }
        };
    }
}

