/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.enums.ResultType;
import com.github.sd4324530.fastweixin.api.response.GetSignatureResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JsApiUtil;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(JsAPI.class);

    public JsAPI(ApiConfig config) {
        super(config);
    }

    public GetSignatureResponse getSignature(String url) {
        BeanUtil.requireNonNull(url, "\u8bf7\u4f20\u5165\u5f53\u524d\u7f51\u9875\u7684URL\uff0c\u4e0d\u5305\u542b#\u53ca\u5176\u540e\u9762\u90e8\u5206");
        long timestame = System.currentTimeMillis() / 1000L;
        String nonceStr = UUID.randomUUID().toString().replaceAll("-", "");
        return this.getSignature(nonceStr, timestame, url);
    }

    public GetSignatureResponse getSignature(String nonceStr, long timestame, String url) {
        String sign;
        BeanUtil.requireNonNull(url, "\u8bf7\u4f20\u5165\u5f53\u524d\u7f51\u9875\u7684URL\uff0c\u4e0d\u5305\u542b#\u53ca\u5176\u540e\u9762\u90e8\u5206");
        GetSignatureResponse response = new GetSignatureResponse();
        String jsApiTicket = this.config.getJsApiTicket();
        try {
            sign = JsApiUtil.sign(jsApiTicket, nonceStr, timestame, url);
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u7b7e\u540d\u5f02\u5e38:", (Throwable)e);
            response.setErrcode(ResultType.OTHER_ERROR.getCode().toString());
            response.setErrmsg("\u83b7\u53d6\u7b7e\u540d\u5f02\u5e38");
            return response;
        }
        response.setNoncestr(nonceStr);
        response.setSignature(sign);
        response.setTimestamp(timestame);
        response.setUrl(url);
        response.setErrcode(ResultType.SUCCESS.getCode().toString());
        return response;
    }
}

