/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.company.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.company.api.QYBaseAPI;
import com.github.sd4324530.fastweixin.company.api.config.QYAPIConfig;
import com.github.sd4324530.fastweixin.company.api.entity.QYMenu;
import com.github.sd4324530.fastweixin.company.api.enums.QYResultType;
import com.github.sd4324530.fastweixin.company.api.response.GetQYMenuResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.CollectionUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QYMenuAPI
extends QYBaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QYMenuAPI.class);

    public QYMenuAPI(QYAPIConfig config) {
        super(config);
    }

    public QYResultType create(QYMenu menu, String agentId) {
        BeanUtil.requireNonNull(menu, "\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/menu/create?access_token=#&agentid=" + agentId;
        BaseResponse response = this.executePost(url, JSONUtil.toJson(menu));
        return QYResultType.get(response.getErrcode());
    }

    public GetQYMenuResponse list(String agentId) {
        GetQYMenuResponse response;
        BeanUtil.requireNonNull(agentId, "\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/menu/get?access_token=#&agentid=" + agentId;
        BaseResponse r = this.executeGet(url);
        if (this.isSuccess(r.getErrcode())) {
            JSONObject jsonObject = JSONUtil.getJSONFromString(r.getErrmsg());
            List buttonList = (List)JSONPath.eval((Object)jsonObject, (String)"$.menu.button");
            if (CollectionUtil.isNotEmpty(buttonList)) {
                for (Object button : buttonList) {
                    List subList = (List)JSONPath.eval(button, (String)"$.sub_button");
                    if (CollectionUtil.isNotEmpty(subList)) {
                        for (Object sub : subList) {
                            Object type = JSONPath.eval(sub, (String)"$.type");
                            JSONPath.set(sub, (String)"$.type", (Object)type.toString().toUpperCase());
                        }
                        continue;
                    }
                    Object type = JSONPath.eval(button, (String)"$.type");
                    JSONPath.set(button, (String)"$.type", (Object)type.toString().toUpperCase());
                }
            }
            response = JSONUtil.toBean(jsonObject.toJSONString(), GetQYMenuResponse.class);
        } else {
            response = JSONUtil.toBean(r.toJsonString(), GetQYMenuResponse.class);
        }
        return response;
    }

    public QYResultType delete(String agentId) {
        BeanUtil.requireNonNull(agentId, "AgentId\u4e0d\u80fd\u4e3a\u7a7a");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/menu/delete?access_token=#&agentid=" + agentId;
        BaseResponse response = this.executeGet(url);
        return QYResultType.get(response.getErrcode());
    }
}

