/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.company.api;

import com.github.sd4324530.fastweixin.api.enums.OauthScope;
import com.github.sd4324530.fastweixin.company.api.QYBaseAPI;
import com.github.sd4324530.fastweixin.company.api.config.QYAPIConfig;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QYOauthAPI
extends QYBaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QYOauthAPI.class);

    public QYOauthAPI(QYAPIConfig config) {
        super(config);
    }

    public String getOauthPageUrl(String redirectUrl, OauthScope scope, String state) {
        if (StrUtil.isBlank(redirectUrl)) {
            throw new NullPointerException("redirectUrl is null");
        }
        BeanUtil.requireNonNull((Object)scope, "scope is null");
        String userstate = StrUtil.isBlank(state) ? "STATE" : state;
        String url = null;
        try {
            url = URLEncoder.encode(redirectUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("\u5f02\u5e38", (Throwable)e);
        }
        StringBuffer stringBuffer = new StringBuffer("https://open.weixin.qq.com/connect/oauth2/authorize?");
        stringBuffer.append("appid=").append(this.config.getCorpid()).append("&redirect_uri=").append(url).append("&response_type=code&scope=").append(scope.toString()).append("&state=").append(userstate).append("#wechat_redirect");
        return stringBuffer.toString();
    }
}

