/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.company.api;

import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.company.api.QYBaseAPI;
import com.github.sd4324530.fastweixin.company.api.config.QYAPIConfig;
import com.github.sd4324530.fastweixin.company.api.entity.QYUser;
import com.github.sd4324530.fastweixin.company.api.enums.QYResultType;
import com.github.sd4324530.fastweixin.company.api.response.GetOauthUserInfoResponse;
import com.github.sd4324530.fastweixin.company.api.response.GetQYUserInfo4DepartmentResponse;
import com.github.sd4324530.fastweixin.company.api.response.GetQYUserInfoResponse;
import com.github.sd4324530.fastweixin.company.api.response.GetQYUserInviteResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.util.HashMap;

public class QYUserAPI
extends QYBaseAPI {
    public QYUserAPI(QYAPIConfig config) {
        super(config);
    }

    public QYResultType create(QYUser user) {
        BeanUtil.requireNonNull(user, "user is null");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=#";
        BaseResponse response = this.executePost(url, user.toJsonString());
        return QYResultType.get(response.getErrcode());
    }

    public QYResultType update(QYUser user) {
        BeanUtil.requireNonNull(user, "user is null");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=#";
        BaseResponse response = this.executePost(url, user.toJsonString());
        return QYResultType.get(response.getErrcode());
    }

    public QYResultType delete(String userId) {
        BeanUtil.requireNonNull(userId, "userId is null");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?access_token=#&userid=" + userId;
        BaseResponse response = this.executeGet(url);
        return QYResultType.get(response.getErrcode());
    }

    public QYResultType batchdelete(String[] userIds) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete?access_token=#";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("useridlist", userIds);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(params));
        return QYResultType.get(response.getErrcode());
    }

    public GetQYUserInfoResponse get(String userId) {
        BeanUtil.requireNonNull(userId, "userId is null");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=#&userid=" + userId;
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetQYUserInfoResponse response = JSONUtil.toBean(resultJson, GetQYUserInfoResponse.class);
        return response;
    }

    public GetQYUserInfo4DepartmentResponse simpleList(Integer departmentId, boolean isLoop, Integer status) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=#&department_id=" + departmentId + "&fetch_child=" + (isLoop ? 0 : 1) + "&status=" + status;
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetQYUserInfo4DepartmentResponse response = JSONUtil.toBean(resultJson, GetQYUserInfo4DepartmentResponse.class);
        return response;
    }

    public GetQYUserInfo4DepartmentResponse getList(Integer departmentId, boolean isLoop, Integer status) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=#&department_id=" + departmentId + "&fetch_child=" + (isLoop ? 0 : 1) + "&status=" + status;
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetQYUserInfo4DepartmentResponse response = JSONUtil.toBean(resultJson, GetQYUserInfo4DepartmentResponse.class);
        return response;
    }

    public GetQYUserInviteResponse invite(String userid) {
        BeanUtil.requireNonNull(userid, "userid is null");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/invite/send?access_token=#";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", userid);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetQYUserInviteResponse response = JSONUtil.toBean(resultJson, GetQYUserInviteResponse.class);
        return response;
    }

    public GetOauthUserInfoResponse getOauthUserInfo(String code) {
        if (StrUtil.isBlank(code)) {
            throw new NullPointerException("code is null");
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=#&code=" + code;
        BaseResponse r = this.executeGet(url);
        String jsonResult = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetOauthUserInfoResponse response = JSONUtil.toBean(jsonResult, GetOauthUserInfoResponse.class);
        return response;
    }
}

