/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.company.api.config;

import com.github.sd4324530.fastweixin.api.config.ChangeType;
import com.github.sd4324530.fastweixin.api.config.ConfigChangeNotice;
import com.github.sd4324530.fastweixin.api.response.GetJsApiTicketResponse;
import com.github.sd4324530.fastweixin.api.response.GetTokenResponse;
import com.github.sd4324530.fastweixin.exception.WeixinException;
import com.github.sd4324530.fastweixin.handle.ApiConfigChangeHandle;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.NetWorkCenter;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QYAPIConfig
extends Observable
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(QYAPIConfig.class);
    private final Integer CACHE_TIME = 7100000;
    private final AtomicBoolean tokenRefreshing = new AtomicBoolean(false);
    private final AtomicBoolean jsRefreshing = new AtomicBoolean(false);
    private final String corpid;
    private final String corpsecret;
    private String accessToken;
    private String jsApiTicket;
    private boolean enableJsApi;
    private long jsTokenStartTime;
    private long weixinTokenStartTime;

    public QYAPIConfig(String corpID, String corpSecret) {
        this(corpID, corpSecret, false);
    }

    public QYAPIConfig(String corpid, String corpsecret, boolean enableJsApi) {
        this.corpid = corpid;
        this.corpsecret = corpsecret;
        this.enableJsApi = enableJsApi;
    }

    public String getCorpid() {
        return this.corpid;
    }

    public String getCorpsecret() {
        return this.corpsecret;
    }

    public String getAccessToken() {
        long now = System.currentTimeMillis();
        long time = now - this.weixinTokenStartTime;
        try {
            if (time > (long)this.CACHE_TIME.intValue() && this.tokenRefreshing.compareAndSet(false, true)) {
                LOG.debug("\u51c6\u5907\u5237\u65b0tokean.........");
                this.initToken(now);
            }
        }
        catch (Exception e) {
            LOG.error("\u5237\u65b0token\u5f02\u5e38", (Throwable)e);
            this.tokenRefreshing.set(false);
        }
        return this.accessToken;
    }

    public String getJsApiTicket() {
        if (this.enableJsApi) {
            long now = System.currentTimeMillis();
            long time = now - this.jsTokenStartTime;
            try {
                if (now - this.jsTokenStartTime > (long)this.CACHE_TIME.intValue() && this.jsRefreshing.compareAndSet(false, true)) {
                    LOG.debug("\u51c6\u5907\u5237\u65b0JSTokean..........");
                    this.getAccessToken();
                    this.initJSToken(now);
                }
            }
            catch (Exception e) {
                LOG.error("\u5237\u65b0jsToken\u5f02\u5e38", (Throwable)e);
                this.jsRefreshing.set(false);
            }
        } else {
            this.jsApiTicket = null;
        }
        return this.jsApiTicket;
    }

    public boolean isEnableJsApi() {
        return this.enableJsApi;
    }

    public void setEnableJsApi(boolean enableJsApi) {
        this.enableJsApi = enableJsApi;
        if (!enableJsApi) {
            this.jsApiTicket = null;
        }
    }

    public void addHandle(ApiConfigChangeHandle handle) {
        super.addObserver(handle);
    }

    public void removeHandle(ApiConfigChangeHandle handle) {
        super.deleteObserver(handle);
    }

    public void removeAllHandle() {
        super.deleteObservers();
    }

    private void initToken(long refreshTime) {
        LOG.debug("\u5f00\u59cb\u521d\u59cb\u5316access_token..........");
        final long oldTime = this.weixinTokenStartTime;
        this.weixinTokenStartTime = refreshTime;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + this.corpid + "&corpsecret=" + this.corpsecret;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback(){

            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (200 == resultCode) {
                    GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                    LOG.debug("\u83b7\u53d6access_token:{}", (Object)response.getAccessToken());
                    if (null == response.getAccessToken()) {
                        QYAPIConfig.this.weixinTokenStartTime = oldTime;
                        throw new WeixinException("\u5fae\u4fe1\u4f01\u4e1a\u53f7token\u83b7\u53d6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:" + response.getErrcode() + "," + response.getErrmsg());
                    }
                    QYAPIConfig.this.accessToken = response.getAccessToken();
                    QYAPIConfig.this.setChanged();
                    QYAPIConfig.this.notifyObservers(new ConfigChangeNotice(QYAPIConfig.this.corpid, ChangeType.ACCESS_TOKEN, QYAPIConfig.this.accessToken));
                }
            }
        });
        this.tokenRefreshing.set(false);
    }

    private void initJSToken(long refreshTime) {
        LOG.debug("\u521d\u59cb\u5316 jsapi_ticket.........");
        final long oldTime = this.jsTokenStartTime;
        this.jsTokenStartTime = refreshTime;
        String url = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=" + this.accessToken;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback(){

            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (200 == resultCode) {
                    GetJsApiTicketResponse response = JSONUtil.toBean(resultJson, GetJsApiTicketResponse.class);
                    LOG.debug("\u83b7\u53d6jsapi_ticket:{}", (Object)response.getTicket());
                    if (StrUtil.isBlank(response.getTicket())) {
                        QYAPIConfig.this.jsTokenStartTime = oldTime;
                        throw new WeixinException("\u5fae\u4fe1\u4f01\u4e1a\u53f7jsToken\u83b7\u53d6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:" + response.getErrcode() + "," + response.getErrmsg());
                    }
                    QYAPIConfig.this.jsApiTicket = response.getTicket();
                    QYAPIConfig.this.setChanged();
                    QYAPIConfig.this.notifyObservers(new ConfigChangeNotice(QYAPIConfig.this.corpid, ChangeType.JS_TOKEN, QYAPIConfig.this.jsApiTicket));
                }
            }
        });
        this.jsRefreshing.set(false);
    }
}

