/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.servlet;

import com.github.sd4324530.fastweixin.handle.EventHandle;
import com.github.sd4324530.fastweixin.handle.MessageHandle;
import com.github.sd4324530.fastweixin.message.BaseMsg;
import com.github.sd4324530.fastweixin.message.TextMsg;
import com.github.sd4324530.fastweixin.message.aes.AesException;
import com.github.sd4324530.fastweixin.message.aes.WXBizMsgCrypt;
import com.github.sd4324530.fastweixin.message.req.BaseEvent;
import com.github.sd4324530.fastweixin.message.req.BaseReq;
import com.github.sd4324530.fastweixin.message.req.BaseReqMsg;
import com.github.sd4324530.fastweixin.message.req.ImageReqMsg;
import com.github.sd4324530.fastweixin.message.req.LinkReqMsg;
import com.github.sd4324530.fastweixin.message.req.LocationEvent;
import com.github.sd4324530.fastweixin.message.req.LocationReqMsg;
import com.github.sd4324530.fastweixin.message.req.MenuEvent;
import com.github.sd4324530.fastweixin.message.req.QrCodeEvent;
import com.github.sd4324530.fastweixin.message.req.ScanCodeEvent;
import com.github.sd4324530.fastweixin.message.req.SendMessageEvent;
import com.github.sd4324530.fastweixin.message.req.SendPicsInfoEvent;
import com.github.sd4324530.fastweixin.message.req.TemplateMsgEvent;
import com.github.sd4324530.fastweixin.message.req.TextReqMsg;
import com.github.sd4324530.fastweixin.message.req.VideoReqMsg;
import com.github.sd4324530.fastweixin.message.req.VoiceReqMsg;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.CollectionUtil;
import com.github.sd4324530.fastweixin.util.MessageUtil;
import com.github.sd4324530.fastweixin.util.SignUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WeixinSupport {
    private static final Logger LOG = LoggerFactory.getLogger(WeixinSupport.class);
    private static final Object LOCK = new Object();
    private static List<MessageHandle> messageHandles;
    private static List<EventHandle> eventHandles;

    protected List<MessageHandle> initMessageHandles() {
        return null;
    }

    protected List<EventHandle> initEventHandles() {
        return null;
    }

    protected abstract String getToken();

    protected String getAppId() {
        return null;
    }

    protected String getAESKey() {
        return null;
    }

    public void bindServer(HttpServletRequest request, HttpServletResponse response) {
        if (this.isLegal(request)) {
            try {
                PrintWriter pw = response.getWriter();
                pw.write(request.getParameter("echostr"));
                pw.flush();
                pw.close();
            }
            catch (Exception e) {
                LOG.error("\u7ed1\u5b9a\u670d\u52a1\u5668\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public String processRequest(HttpServletRequest request) {
        String mediaId;
        Map<String, Object> reqMap = MessageUtil.parseXml(request, this.getToken(), this.getAppId(), this.getAESKey());
        String fromUserName = (String)reqMap.get("FromUserName");
        String toUserName = (String)reqMap.get("ToUserName");
        String msgType = (String)reqMap.get("MsgType");
        LOG.debug("\u6536\u5230\u6d88\u606f,\u6d88\u606f\u7c7b\u578b:{}", (Object)msgType);
        BaseMsg msg = null;
        if (msgType.equals("event")) {
            String msgId;
            BaseEvent event;
            String eventKey;
            String eventType = (String)reqMap.get("Event");
            String ticket = (String)reqMap.get("Ticket");
            QrCodeEvent qrCodeEvent = null;
            if (StrUtil.isNotBlank(ticket)) {
                eventKey = (String)reqMap.get("EventKey");
                LOG.debug("eventKey:{}", (Object)eventKey);
                LOG.debug("ticket:{}", (Object)ticket);
                qrCodeEvent = new QrCodeEvent(eventKey, ticket);
                this.buildBasicEvent(reqMap, qrCodeEvent);
                if (eventType.equals("SCAN") && BeanUtil.isNull(msg = this.handleQrCodeEvent(qrCodeEvent))) {
                    msg = this.processEventHandle(qrCodeEvent);
                }
            }
            if (eventType.equals("subscribe")) {
                event = new BaseEvent();
                if (qrCodeEvent != null) {
                    event = qrCodeEvent;
                } else {
                    this.buildBasicEvent(reqMap, event);
                }
                msg = this.handleSubscribe(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if (eventType.equals("unsubscribe")) {
                event = new BaseEvent();
                this.buildBasicEvent(reqMap, event);
                msg = this.handleUnsubscribe(event);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event);
                }
            } else if (eventType.equals("CLICK")) {
                eventKey = (String)reqMap.get("EventKey");
                LOG.debug("eventKey:{}", (Object)eventKey);
                MenuEvent event2 = new MenuEvent(eventKey);
                this.buildBasicEvent(reqMap, event2);
                msg = this.handleMenuClickEvent(event2);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event2);
                }
            } else if (eventType.equals("VIEW")) {
                eventKey = (String)reqMap.get("EventKey");
                LOG.debug("eventKey:{}", (Object)eventKey);
                MenuEvent event3 = new MenuEvent(eventKey);
                this.buildBasicEvent(reqMap, event3);
                msg = this.handleMenuViewEvent(event3);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event3);
                }
            } else if (eventType.equals("LOCATION")) {
                double latitude = Double.parseDouble((String)reqMap.get("Latitude"));
                double longitude = Double.parseDouble((String)reqMap.get("Longitude"));
                double precision = Double.parseDouble((String)reqMap.get("Precision"));
                LocationEvent event4 = new LocationEvent(latitude, longitude, precision);
                this.buildBasicEvent(reqMap, event4);
                msg = this.handleLocationEvent(event4);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event4);
                }
            } else if ("scancode_push".equals(eventType) || "scancode_waitmsg".equals(eventType)) {
                eventKey = (String)reqMap.get("EventKey");
                Map scanCodeInfo = (Map)reqMap.get("ScanCodeInfo");
                String scanType = (String)scanCodeInfo.get("ScanType");
                String scanResult = (String)scanCodeInfo.get("ScanResult");
                ScanCodeEvent event5 = new ScanCodeEvent(eventKey, scanType, scanResult);
                this.buildBasicEvent(reqMap, event5);
                msg = this.handleScanCodeEvent(event5);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event5);
                }
            } else if ("pic_photo_or_album".equals(eventType) || "pic_sysphoto".equals(eventType) || "pic_weixin".equals(eventType)) {
                eventKey = (String)reqMap.get("EventKey");
                Map sendPicsInfo = (Map)reqMap.get("SendPicsInfo");
                int count = Integer.parseInt((String)sendPicsInfo.get("Count"));
                List picList = (List)sendPicsInfo.get("PicList");
                SendPicsInfoEvent event6 = new SendPicsInfoEvent(eventKey, count, picList);
                this.buildBasicEvent(reqMap, event6);
                msg = this.handlePSendPicsInfoEvent(event6);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event6);
                }
            } else if ("TEMPLATESENDJOBFINISH".equals(eventType)) {
                msgId = (String)reqMap.get("MsgID");
                String status = (String)reqMap.get("Status");
                TemplateMsgEvent event7 = new TemplateMsgEvent(msgId, status);
                this.buildBasicEvent(reqMap, event7);
                msg = this.handleTemplateMsgEvent(event7);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event7);
                }
            } else if ("MASSSENDJOBFINISH".equals(eventType)) {
                msgId = (String)reqMap.get("MsgID");
                String status = (String)reqMap.get("Status");
                Integer TotalCount = Integer.valueOf(String.valueOf(reqMap.get("TotalCount")));
                Integer filterCount = Integer.valueOf(String.valueOf(reqMap.get("FilterCount")));
                Integer sentCount = Integer.valueOf(String.valueOf(reqMap.get("SentCount")));
                Integer errorCount = Integer.valueOf(String.valueOf(reqMap.get("ErrorCount")));
                SendMessageEvent event8 = new SendMessageEvent(msgId, status, TotalCount, filterCount, sentCount, errorCount);
                this.buildBasicEvent(reqMap, event8);
                msg = this.callBackAllMessage(event8);
                if (BeanUtil.isNull(msg)) {
                    msg = this.processEventHandle(event8);
                }
            }
        } else if (msgType.equals("text")) {
            String content = (String)reqMap.get("Content");
            LOG.debug("\u6587\u672c\u6d88\u606f\u5185\u5bb9:{}", (Object)content);
            TextReqMsg textReqMsg = new TextReqMsg(content);
            this.buildBasicReqMsg(reqMap, textReqMsg);
            msg = this.handleTextMsg(textReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(textReqMsg);
            }
        } else if (msgType.equals("image")) {
            String picUrl = (String)reqMap.get("PicUrl");
            mediaId = (String)reqMap.get("MediaId");
            ImageReqMsg imageReqMsg = new ImageReqMsg(picUrl, mediaId);
            this.buildBasicReqMsg(reqMap, imageReqMsg);
            msg = this.handleImageMsg(imageReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(imageReqMsg);
            }
        } else if (msgType.equals("voice")) {
            String format = (String)reqMap.get("Format");
            mediaId = (String)reqMap.get("MediaId");
            String recognition = (String)reqMap.get("Recognition");
            VoiceReqMsg voiceReqMsg = new VoiceReqMsg(mediaId, format, recognition);
            this.buildBasicReqMsg(reqMap, voiceReqMsg);
            msg = this.handleVoiceMsg(voiceReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(voiceReqMsg);
            }
        } else if (msgType.equals("video")) {
            String thumbMediaId = (String)reqMap.get("ThumbMediaId");
            mediaId = (String)reqMap.get("MediaId");
            VideoReqMsg videoReqMsg = new VideoReqMsg(mediaId, thumbMediaId);
            this.buildBasicReqMsg(reqMap, videoReqMsg);
            msg = this.handleVideoMsg(videoReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(videoReqMsg);
            }
        } else if (msgType.equals("shortvideo")) {
            String thumbMediaId = (String)reqMap.get("ThumbMediaId");
            mediaId = (String)reqMap.get("MediaId");
            VideoReqMsg videoReqMsg = new VideoReqMsg(mediaId, thumbMediaId);
            this.buildBasicReqMsg(reqMap, videoReqMsg);
            msg = this.hadnleShortVideoMsg(videoReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(videoReqMsg);
            }
        } else if (msgType.equals("location")) {
            double locationX = Double.parseDouble((String)reqMap.get("Location_X"));
            double locationY = Double.parseDouble((String)reqMap.get("Location_Y"));
            int scale = Integer.parseInt((String)reqMap.get("Scale"));
            String label = (String)reqMap.get("Label");
            LocationReqMsg locationReqMsg = new LocationReqMsg(locationX, locationY, scale, label);
            this.buildBasicReqMsg(reqMap, locationReqMsg);
            msg = this.handleLocationMsg(locationReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(locationReqMsg);
            }
        } else if (msgType.equals("link")) {
            String title = (String)reqMap.get("Title");
            String description = (String)reqMap.get("Description");
            String url = (String)reqMap.get("Url");
            LOG.debug("\u94fe\u63a5\u6d88\u606f\u5730\u5740:{}", (Object)url);
            LinkReqMsg linkReqMsg = new LinkReqMsg(title, description, url);
            this.buildBasicReqMsg(reqMap, linkReqMsg);
            msg = this.handleLinkMsg(linkReqMsg);
            if (BeanUtil.isNull(msg)) {
                msg = this.processMessageHandle(linkReqMsg);
            }
        }
        String result = "";
        if (BeanUtil.nonNull(msg)) {
            msg.setFromUserName(toUserName);
            msg.setToUserName(fromUserName);
            result = msg.toXml();
            if (StrUtil.isNotBlank(this.getAESKey())) {
                try {
                    WXBizMsgCrypt pc = new WXBizMsgCrypt(this.getToken(), this.getAESKey(), this.getAppId());
                    result = pc.encryptMsg(result, request.getParameter("timestamp"), request.getParameter("nonce"));
                    LOG.debug("\u52a0\u5bc6\u540e\u5bc6\u6587:{}", (Object)result);
                }
                catch (AesException e) {
                    LOG.error("\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseMsg processMessageHandle(BaseReqMsg msg) {
        if (CollectionUtil.isEmpty(messageHandles)) {
            Object object = LOCK;
            synchronized (object) {
                messageHandles = this.initMessageHandles();
            }
        }
        if (CollectionUtil.isNotEmpty(messageHandles)) {
            for (MessageHandle messageHandle : messageHandles) {
                boolean result;
                BaseMsg resultMsg = null;
                try {
                    result = messageHandle.beforeHandle(msg);
                }
                catch (Exception e) {
                    result = false;
                }
                if (result) {
                    resultMsg = messageHandle.handle(msg);
                }
                if (!BeanUtil.nonNull(resultMsg)) continue;
                return resultMsg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseMsg processEventHandle(BaseEvent event) {
        if (CollectionUtil.isEmpty(eventHandles)) {
            Object object = LOCK;
            synchronized (object) {
                eventHandles = this.initEventHandles();
            }
        }
        if (CollectionUtil.isNotEmpty(eventHandles)) {
            for (EventHandle eventHandle : eventHandles) {
                boolean result;
                BaseMsg resultMsg = null;
                try {
                    result = eventHandle.beforeHandle(event);
                }
                catch (Exception e) {
                    result = false;
                }
                if (result) {
                    resultMsg = eventHandle.handle(event);
                }
                if (!BeanUtil.nonNull(resultMsg)) continue;
                return resultMsg;
            }
        }
        return null;
    }

    protected BaseMsg handleTextMsg(TextReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected BaseMsg handleImageMsg(ImageReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected BaseMsg handleVoiceMsg(VoiceReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected BaseMsg handleVideoMsg(VideoReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected BaseMsg hadnleShortVideoMsg(VideoReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected BaseMsg handleLocationMsg(LocationReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected BaseMsg handleLinkMsg(LinkReqMsg msg) {
        return this.handleDefaultMsg(msg);
    }

    protected BaseMsg handleQrCodeEvent(QrCodeEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected BaseMsg handleLocationEvent(LocationEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected BaseMsg handleMenuClickEvent(MenuEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected BaseMsg handleMenuViewEvent(MenuEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected BaseMsg handleScanCodeEvent(ScanCodeEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected BaseMsg handlePSendPicsInfoEvent(SendPicsInfoEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected BaseMsg handleTemplateMsgEvent(TemplateMsgEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected BaseMsg handleSubscribe(BaseEvent event) {
        return new TextMsg("\u611f\u8c22\u60a8\u7684\u5173\u6ce8!");
    }

    protected BaseMsg callBackAllMessage(SendMessageEvent event) {
        return this.handleDefaultEvent(event);
    }

    protected BaseMsg handleUnsubscribe(BaseEvent event) {
        return null;
    }

    protected BaseMsg handleDefaultMsg(BaseReqMsg msg) {
        return null;
    }

    protected BaseMsg handleDefaultEvent(BaseEvent event) {
        return null;
    }

    private void buildBasicReqMsg(Map<String, Object> reqMap, BaseReqMsg reqMsg) {
        this.addBasicReqParams(reqMap, reqMsg);
        reqMsg.setMsgId((String)reqMap.get("MsgId"));
    }

    private void buildBasicEvent(Map<String, Object> reqMap, BaseEvent event) {
        this.addBasicReqParams(reqMap, event);
        event.setEvent((String)reqMap.get("Event"));
    }

    private void addBasicReqParams(Map<String, Object> reqMap, BaseReq req) {
        req.setMsgType((String)reqMap.get("MsgType"));
        req.setFromUserName((String)reqMap.get("FromUserName"));
        req.setToUserName((String)reqMap.get("ToUserName"));
        req.setCreateTime(Long.parseLong((String)reqMap.get("CreateTime")));
    }

    protected boolean isLegal(HttpServletRequest request) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        return SignUtil.checkSignature(this.getToken(), signature, timestamp, nonce);
    }
}

