/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.enums;

import com.xkzhangsan.time.constants.Constant;
import java.time.MonthDay;
import java.util.Objects;

public enum ConstellationNameEnum {
    Aries(1, "\u767d\u7f8a\u5ea7", "03-21", "04-19"),
    Taurus(2, "\u91d1\u725b\u5ea7", "04-20", "05-20"),
    Gemini(3, "\u53cc\u5b50\u5ea7", "05-21", "06-21"),
    Cancer(4, "\u5de8\u87f9\u5ea7", "06-22", "07-22"),
    Leo(5, "\u72ee\u5b50\u5ea7", "07-23", "08-22"),
    Virgo(6, "\u5904\u5973\u5ea7", "08-23", "09-22"),
    Libra(7, "\u5929\u79e4\u5ea7", "09-23", "10-23"),
    Scorpio(8, "\u5929\u874e\u5ea7", "10-24", "11-22"),
    Sagittarius(9, "\u5c04\u624b\u5ea7", "11-23", "12-21"),
    Capricorn(10, "\u6469\u7faf\u5ea7", "12-22", "01-19"),
    Aquarius(11, "\u6c34\u74f6\u5ea7", "01-20", "02-18"),
    Pisces(12, "\u53cc\u9c7c\u5ea7", "02-19", "03-20");

    private int code;
    private String nameCn;
    private String startDate;
    private String endDate;

    private ConstellationNameEnum(int code, String nameCn, String startDate, String endDate) {
        this.code = code;
        this.nameCn = nameCn;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public static ConstellationNameEnum getConstellationNameEnumByMonthDay(String monthDayStr) {
        Objects.requireNonNull(monthDayStr, "monthDayStr");
        MonthDay monthDay = MonthDay.parse("--" + monthDayStr);
        for (ConstellationNameEnum constellationNameEnum : ConstellationNameEnum.values()) {
            MonthDay monthDayEnd;
            if (constellationNameEnum.getStartDate().equals(monthDayStr) || constellationNameEnum.getEndDate().equals(monthDayStr)) {
                return constellationNameEnum;
            }
            MonthDay monthDayStart = MonthDay.parse("--" + constellationNameEnum.getStartDate());
            if (ConstellationNameEnum.isCapricorn(monthDay, monthDayStart, monthDayEnd = MonthDay.parse("--" + constellationNameEnum.getEndDate()))) {
                return Capricorn;
            }
            if (!monthDay.isAfter(monthDayStart) || !monthDay.isBefore(monthDayEnd)) continue;
            return constellationNameEnum;
        }
        return null;
    }

    private static boolean isCapricorn(MonthDay monthDay, MonthDay monthDayStart, MonthDay monthDayEnd) {
        if (Constant.MONTH_DAY_START.equals(monthDay) || Constant.MONTH_DAY_END.equals(monthDay)) {
            return true;
        }
        if (monthDay.isAfter(Constant.CAPRICORN_START) && monthDay.isBefore(Constant.MONTH_DAY_END)) {
            return true;
        }
        return monthDay.isAfter(Constant.MONTH_DAY_START) && monthDay.isBefore(Constant.CAPRICORN_END);
    }

    public static String getNameCnByMonthDay(String monthDayStr) {
        ConstellationNameEnum constellationNameEnum = ConstellationNameEnum.getConstellationNameEnumByMonthDay(monthDayStr);
        return constellationNameEnum != null ? constellationNameEnum.getNameCn() : null;
    }

    public static String getNameEnByMonthDay(String monthDayStr) {
        ConstellationNameEnum constellationNameEnum = ConstellationNameEnum.getConstellationNameEnumByMonthDay(monthDayStr);
        return constellationNameEnum != null ? constellationNameEnum.name() : null;
    }

    public int getCode() {
        return this.code;
    }

    public String getNameCn() {
        return this.nameCn;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }
}

