/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.extensions.Email;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.YtStatus;
import com.google.gdata.data.youtube.YtUsername;
import com.google.gdata.util.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://gdata.youtube.com/schemas/2007#friend")
public class FriendEntry
extends BaseEntry<FriendEntry> {
    public static final String[] CATEGORIES = new String[]{"http://gdata.youtube.com/schemas/2007/contact.cat"};

    public FriendEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#friend");
    }

    public FriendEntry(BaseEntry<?> base) {
        super(base);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#friend");
    }

    public String getUsername() {
        YtUsername username = this.getExtension(YtUsername.class);
        return username == null ? null : username.getContent();
    }

    public void setUsername(String name) {
        if (name == null) {
            this.removeExtension(YtUsername.class);
        } else {
            this.setExtension(new YtUsername(name));
        }
    }

    public void setStatus(YtStatus.Value status) {
        if (status == null) {
            this.removeExtension(YtStatus.class);
        } else {
            this.setExtension(new YtStatus(status));
        }
    }

    public YtStatus.Value getStatus() {
        YtStatus status = this.getExtension(YtStatus.class);
        return status == null ? null : status.getStatus();
    }

    public String getUserProfileLink() {
        Link link = this.getLink("related", ILink.Type.ATOM);
        return link == null ? null : link.getHref();
    }

    public void addUserProfileLink(String url) {
        Link link = new Link();
        link.setRel("related");
        link.setType(ILink.Type.ATOM);
        link.setHref(url);
        this.getLinks().add(link);
    }

    public Email getEmail() {
        return this.getExtension(Email.class);
    }

    public void setEmail(Email email) {
        if (email == null) {
            this.removeExtension(Email.class);
        } else {
            this.setExtension(email);
        }
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(FriendEntry.class, YtStatus.class);
        extProfile.declare(FriendEntry.class, YtUsername.class);
        ExtensionDescription emailExtension = Email.getDefaultDescription();
        emailExtension.setRepeatable(false);
        extProfile.declare(FriendEntry.class, emailExtension);
        extProfile.declareAdditionalNamespace(Namespaces.gNs);
        extProfile.declareArbitraryXmlExtension(FriendEntry.class);
    }
}

