/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="yt", nsUri="http://gdata.youtube.com/schemas/2007", localName="formatInfo")
public class YtFormatInfo
extends AbstractExtension {
    private static final String FORMAT = "format";
    private static final String FRAME_RATE = "frameRate";
    private static final String TIME_OFFSET = "timeOffset";
    private static final String DROP_FRAME = "dropFrame";
    private String format;
    private String frameRate;
    private String timeOffset;
    private boolean dropFrame;

    public YtFormatInfo() {
        this.dropFrame = false;
    }

    public YtFormatInfo(String format, String frameRate, String timeOffset, boolean dropFrame) {
        this.format = format;
        this.frameRate = frameRate;
        this.timeOffset = timeOffset;
        this.dropFrame = dropFrame;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(String frameRate) {
        this.frameRate = frameRate;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public boolean getDropFrame() {
        return this.dropFrame;
    }

    public void setDropFrame(boolean dropFrame) {
        this.dropFrame = dropFrame;
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        super.consumeAttributes(helper);
        this.format = helper.consume(FORMAT, false);
        this.frameRate = helper.consume(FRAME_RATE, false);
        this.timeOffset = helper.consume(TIME_OFFSET, false);
        this.dropFrame = helper.consumeBoolean(DROP_FRAME, false);
    }

    protected void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        if (this.format != null) {
            generator.put(FORMAT, this.format);
        }
        if (this.frameRate != null) {
            generator.put(FRAME_RATE, this.frameRate);
        }
        if (this.timeOffset != null) {
            generator.put(TIME_OFFSET, this.timeOffset);
        }
        if (this.dropFrame) {
            generator.put(DROP_FRAME, this.dropFrame);
        }
    }
}

