/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.output.media;

import com.google.gdata.data.media.GDataContentHandler;
import com.google.gdata.data.media.MediaMultipart;
import com.google.gdata.util.InvalidEntryException;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.output.OutputGenerator;
import com.google.gdata.wireformats.output.OutputProperties;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaMultipartGenerator
implements OutputGenerator<MediaMultipart> {
    @Override
    public AltFormat getAltFormat() {
        return AltFormat.MEDIA_MULTIPART;
    }

    @Override
    public Class<MediaMultipart> getSourceType() {
        return MediaMultipart.class;
    }

    @Override
    public void generate(OutputStream contentStream, OutputProperties request, MediaMultipart source) throws IOException {
        OutputProperties prevProperties = null;
        try {
            prevProperties = GDataContentHandler.setThreadOutputProperties(request);
            source.writeTo(contentStream);
        }
        catch (MessagingException me) {
            Throwable t = me.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            IOException ioe = new IOException("Invalid multipart content");
            ioe.initCause(new InvalidEntryException("Invalid media entry", (Throwable)me));
            throw ioe;
        }
        finally {
            GDataContentHandler.setThreadOutputProperties(prevProperties);
        }
    }
}

