/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.CustomFunctionLoader;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.code.OptimizeCodeGenerator;
import com.googlecode.aviator.code.asm.ASMCodeGenerator;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.lexer.ExpressionLexer;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.parser.ExpressionParser;
import com.googlecode.aviator.runtime.function.math.MathAbsFunction;
import com.googlecode.aviator.runtime.function.math.MathCosFunction;
import com.googlecode.aviator.runtime.function.math.MathLog10Function;
import com.googlecode.aviator.runtime.function.math.MathLogFunction;
import com.googlecode.aviator.runtime.function.math.MathPowFunction;
import com.googlecode.aviator.runtime.function.math.MathRoundFunction;
import com.googlecode.aviator.runtime.function.math.MathSinFunction;
import com.googlecode.aviator.runtime.function.math.MathSqrtFunction;
import com.googlecode.aviator.runtime.function.math.MathTanFunction;
import com.googlecode.aviator.runtime.function.seq.SeqCountFunction;
import com.googlecode.aviator.runtime.function.seq.SeqFilterFunction;
import com.googlecode.aviator.runtime.function.seq.SeqIncludeFunction;
import com.googlecode.aviator.runtime.function.seq.SeqMakePredicateFunFunction;
import com.googlecode.aviator.runtime.function.seq.SeqMapFunction;
import com.googlecode.aviator.runtime.function.seq.SeqReduceFunction;
import com.googlecode.aviator.runtime.function.seq.SeqSortFunction;
import com.googlecode.aviator.runtime.function.string.StringContainsFunction;
import com.googlecode.aviator.runtime.function.string.StringEndsWithFunction;
import com.googlecode.aviator.runtime.function.string.StringIndexOfFunction;
import com.googlecode.aviator.runtime.function.string.StringJoinFunction;
import com.googlecode.aviator.runtime.function.string.StringLengthFunction;
import com.googlecode.aviator.runtime.function.string.StringReplaceAllFunction;
import com.googlecode.aviator.runtime.function.string.StringReplaceFirstFunction;
import com.googlecode.aviator.runtime.function.string.StringSplitFunction;
import com.googlecode.aviator.runtime.function.string.StringStartsWithFunction;
import com.googlecode.aviator.runtime.function.string.StringSubStringFunction;
import com.googlecode.aviator.runtime.function.system.BinaryFunction;
import com.googlecode.aviator.runtime.function.system.Date2StringFunction;
import com.googlecode.aviator.runtime.function.system.DoubleFunction;
import com.googlecode.aviator.runtime.function.system.LongFunction;
import com.googlecode.aviator.runtime.function.system.NowFunction;
import com.googlecode.aviator.runtime.function.system.PrintFunction;
import com.googlecode.aviator.runtime.function.system.PrintlnFunction;
import com.googlecode.aviator.runtime.function.system.RandomFunction;
import com.googlecode.aviator.runtime.function.system.StrFunction;
import com.googlecode.aviator.runtime.function.system.String2DateFunction;
import com.googlecode.aviator.runtime.function.system.SysDateFunction;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorNil;
import java.io.OutputStream;
import java.math.MathContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;

public final class AviatorEvaluator {
    @Deprecated
    private static AviatorClassLoader aviatorClassLoader;
    public static final int COMPILE = 0;
    public static final int EVAL = 1;
    public static final String VERSION = "2.1.1";
    public static int BYTECODE_VER;
    private static OutputStream traceOutputStream;
    private static final ConcurrentHashMap<Options, Object> options;
    public static final Map<String, Object> FUNC_MAP;
    private static final ConcurrentHashMap<String, FutureTask<Expression>> cacheExpressions;

    public static void setTrace(boolean t) {
        AviatorEvaluator.setOption(Options.TRACE, t);
    }

    public static void setOption(Options opt, Object val) {
        if (opt == null || val == null) {
            throw new IllegalArgumentException("Option and value should not be null.");
        }
        if (!opt.isValidValue(val)) {
            throw new IllegalArgumentException("Invalid value for option:" + opt.name());
        }
        options.put(opt, val);
    }

    public static <T> T getOption(Options opt) {
        Object val = options.get((Object)opt);
        if (val == null) {
            val = opt.getDefaultValue();
        }
        return (T)val;
    }

    public static OutputStream getTraceOutputStream() {
        return traceOutputStream;
    }

    public static MathContext getMathContext() {
        return (MathContext)AviatorEvaluator.getOption(Options.MATH_CONTEXT);
    }

    public static void setMathContext(MathContext mathContext) {
        if (mathContext == null) {
            throw new IllegalArgumentException("null mathContext");
        }
        AviatorEvaluator.setOption(Options.MATH_CONTEXT, mathContext);
    }

    public static void setTraceOutputStream(OutputStream traceOutputStream) {
        AviatorEvaluator.traceOutputStream = traceOutputStream;
    }

    public static void setOptimize(int value) {
        if (value != 0 && value != 1) {
            throw new IllegalArgumentException("Invlaid optimize option value");
        }
        AviatorEvaluator.setOption(Options.OPTIMIZE_LEVEL, value);
    }

    public static void setBYTECODE_VER(int nversion) {
        BYTECODE_VER = nversion;
    }

    private AviatorEvaluator() {
    }

    public static void clearExpressionCache() {
        cacheExpressions.clear();
    }

    public static AviatorClassLoader getAviatorClassLoader() {
        return AviatorEvaluator.getAviatorClassLoader(false);
    }

    public static AviatorClassLoader getAviatorClassLoader(boolean cached) {
        if (cached) {
            return aviatorClassLoader;
        }
        return new AviatorClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static void addFunction(AviatorFunction function) {
        String name = function.getName();
        if (FUNC_MAP.containsKey(name)) {
            System.out.println("[Aviator WARN] The function '" + name + "' is already exists, but you replace it.");
        }
        FUNC_MAP.put(name, function);
    }

    public static AviatorFunction removeFunction(String name) {
        return (AviatorFunction)FUNC_MAP.remove(name);
    }

    public static AviatorFunction getFunction(String name) {
        AviatorFunction function = (AviatorFunction)FUNC_MAP.get(name);
        if (function == null) {
            throw new ExpressionRuntimeException("Could not find function named '" + name + "'");
        }
        return function;
    }

    public static boolean containsFunction(String name) {
        return FUNC_MAP.containsKey(name);
    }

    public static AviatorFunction removeFunction(AviatorFunction function) {
        return AviatorEvaluator.removeFunction(function.getName());
    }

    public static void setAviatorClassLoader(AviatorClassLoader aviatorClassLoader) {
    }

    public static Expression getCachedExpression(String expression) {
        FutureTask<Expression> task = cacheExpressions.get(expression);
        if (task != null) {
            return AviatorEvaluator.getCompiledExpression(expression, task);
        }
        return null;
    }

    public static Expression compile(final String expression, final boolean cached) {
        if (expression == null || expression.trim().length() == 0) {
            throw new CompileExpressionErrorException("Blank expression");
        }
        if (cached) {
            FutureTask<Expression> task = cacheExpressions.get(expression);
            if (task != null) {
                return AviatorEvaluator.getCompiledExpression(expression, task);
            }
            task = new FutureTask<Expression>(new Callable<Expression>(){

                @Override
                public Expression call() throws Exception {
                    return AviatorEvaluator.innerCompile(expression, cached);
                }
            });
            FutureTask<Expression> existedTask = cacheExpressions.putIfAbsent(expression, task);
            if (existedTask == null) {
                existedTask = task;
                existedTask.run();
            }
            return AviatorEvaluator.getCompiledExpression(expression, existedTask);
        }
        return AviatorEvaluator.innerCompile(expression, cached);
    }

    private static Expression getCompiledExpression(String expression, FutureTask<Expression> task) {
        try {
            return task.get();
        }
        catch (Exception e) {
            cacheExpressions.remove(expression);
            throw new CompileExpressionErrorException("Compile expression failure:" + expression, e);
        }
    }

    private static Expression innerCompile(String expression, boolean cached) {
        ExpressionLexer lexer = new ExpressionLexer(expression);
        CodeGenerator codeGenerator = AviatorEvaluator.newCodeGenerator(cached);
        ExpressionParser parser = new ExpressionParser(lexer, codeGenerator);
        return parser.parse();
    }

    private static int getOptimizeLevel() {
        return (Integer)AviatorEvaluator.getOption(Options.OPTIMIZE_LEVEL);
    }

    private static CodeGenerator newCodeGenerator(boolean cached) {
        switch (AviatorEvaluator.getOptimizeLevel()) {
            case 0: {
                ASMCodeGenerator asmCodeGenerator = new ASMCodeGenerator(AviatorEvaluator.getAviatorClassLoader(cached), traceOutputStream, (Boolean)AviatorEvaluator.getOption(Options.TRACE));
                asmCodeGenerator.start();
                return asmCodeGenerator;
            }
            case 1: {
                return new OptimizeCodeGenerator(AviatorEvaluator.getAviatorClassLoader(cached), traceOutputStream, (Boolean)AviatorEvaluator.getOption(Options.TRACE));
            }
        }
        throw new IllegalArgumentException("Unknow option " + AviatorEvaluator.getOptimizeLevel());
    }

    public static Expression compile(String expression) {
        return AviatorEvaluator.compile(expression, false);
    }

    public static Object exec(String expression, Object ... values) {
        if (AviatorEvaluator.getOptimizeLevel() != 1) {
            throw new IllegalStateException("Aviator evaluator is not in EVAL mode.");
        }
        Expression compiledExpression = AviatorEvaluator.compile(expression, true);
        if (compiledExpression != null) {
            List<String> vars = compiledExpression.getVariableNames();
            if (!vars.isEmpty()) {
                int valLen;
                int n = valLen = values == null ? 0 : values.length;
                if (valLen != vars.size()) {
                    throw new IllegalArgumentException("Expect " + vars.size() + " values,but has " + valLen);
                }
                HashMap<String, Object> env = new HashMap<String, Object>();
                int i = 0;
                for (String var : vars) {
                    env.put(var, values[i++]);
                }
                return compiledExpression.execute(env);
            }
            return compiledExpression.execute();
        }
        throw new ExpressionRuntimeException("Null compiled expression for " + expression);
    }

    public static Object execute(String expression, Map<String, Object> env, boolean cached) {
        Expression compiledExpression = AviatorEvaluator.compile(expression, cached);
        if (compiledExpression != null) {
            return compiledExpression.execute(env);
        }
        throw new ExpressionRuntimeException("Null compiled expression for " + expression);
    }

    public static Object execute(String expression, Map<String, Object> env) {
        return AviatorEvaluator.execute(expression, env, false);
    }

    public static void invalidateCache(String expression) {
        cacheExpressions.remove(expression);
    }

    public static Object execute(String expression) {
        return AviatorEvaluator.execute(expression, null);
    }

    static {
        BYTECODE_VER = 50;
        traceOutputStream = System.out;
        options = new ConcurrentHashMap();
        aviatorClassLoader = AccessController.doPrivileged(new PrivilegedAction<AviatorClassLoader>(){

            @Override
            public AviatorClassLoader run() {
                return new AviatorClassLoader(AviatorEvaluator.class.getClassLoader());
            }
        });
        FUNC_MAP = new HashMap<String, Object>();
        AviatorEvaluator.addFunction(new SysDateFunction());
        AviatorEvaluator.addFunction(new PrintlnFunction());
        AviatorEvaluator.addFunction(new PrintFunction());
        AviatorEvaluator.addFunction(new RandomFunction());
        AviatorEvaluator.addFunction(new NowFunction());
        AviatorEvaluator.addFunction(new LongFunction());
        AviatorEvaluator.addFunction(new DoubleFunction());
        AviatorEvaluator.addFunction(new StrFunction());
        AviatorEvaluator.addFunction(new Date2StringFunction());
        AviatorEvaluator.addFunction(new String2DateFunction());
        AviatorEvaluator.addFunction(new BinaryFunction(OperatorType.ADD));
        AviatorEvaluator.addFunction(new BinaryFunction(OperatorType.SUB));
        AviatorEvaluator.addFunction(new BinaryFunction(OperatorType.MULT));
        AviatorEvaluator.addFunction(new BinaryFunction(OperatorType.DIV));
        AviatorEvaluator.addFunction(new BinaryFunction(OperatorType.MOD));
        AviatorEvaluator.addFunction(new BinaryFunction(OperatorType.NEG));
        AviatorEvaluator.addFunction(new BinaryFunction(OperatorType.NOT));
        AviatorEvaluator.addFunction(new StringContainsFunction());
        AviatorEvaluator.addFunction(new StringIndexOfFunction());
        AviatorEvaluator.addFunction(new StringStartsWithFunction());
        AviatorEvaluator.addFunction(new StringEndsWithFunction());
        AviatorEvaluator.addFunction(new StringSubStringFunction());
        AviatorEvaluator.addFunction(new StringLengthFunction());
        AviatorEvaluator.addFunction(new StringSplitFunction());
        AviatorEvaluator.addFunction(new StringJoinFunction());
        AviatorEvaluator.addFunction(new StringReplaceFirstFunction());
        AviatorEvaluator.addFunction(new StringReplaceAllFunction());
        AviatorEvaluator.addFunction(new MathAbsFunction());
        AviatorEvaluator.addFunction(new MathRoundFunction());
        AviatorEvaluator.addFunction(new MathPowFunction());
        AviatorEvaluator.addFunction(new MathSqrtFunction());
        AviatorEvaluator.addFunction(new MathLog10Function());
        AviatorEvaluator.addFunction(new MathLogFunction());
        AviatorEvaluator.addFunction(new MathSinFunction());
        AviatorEvaluator.addFunction(new MathCosFunction());
        AviatorEvaluator.addFunction(new MathTanFunction());
        AviatorEvaluator.addFunction(new SeqMapFunction());
        AviatorEvaluator.addFunction(new SeqReduceFunction());
        AviatorEvaluator.addFunction(new SeqFilterFunction());
        AviatorEvaluator.addFunction(new SeqSortFunction());
        AviatorEvaluator.addFunction(new SeqIncludeFunction());
        AviatorEvaluator.addFunction(new SeqCountFunction());
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.eq", OperatorType.EQ));
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.neq", OperatorType.NEQ));
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.lt", OperatorType.LT));
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.le", OperatorType.LE));
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.gt", OperatorType.GT));
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.ge", OperatorType.GE));
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.true", OperatorType.EQ, AviatorBoolean.TRUE));
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.false", OperatorType.EQ, AviatorBoolean.FALSE));
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.nil", OperatorType.EQ, AviatorNil.NIL));
        AviatorEvaluator.addFunction(new SeqMakePredicateFunFunction("seq.exists", OperatorType.NEQ, AviatorNil.NIL));
        CustomFunctionLoader.load();
        cacheExpressions = new ConcurrentHashMap();
    }
}

