/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CustomFunctionLoader {
    private static String CUSTOM_FUNCTION_LIST_FILE = System.getenv("com.googlecode.aviator.custom_function_config_file");
    private static int tatalCustomFunctions = 0;

    private static void info(String msg) {
        System.out.println("[Aviator INFO] " + msg);
    }

    private static void error(String msg) {
        System.out.println("[Aviator ERROR] " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        BufferedReader reader;
        InputStreamReader inreader;
        InputStream in;
        block8: {
            in = null;
            inreader = null;
            reader = null;
            try {
                in = CustomFunctionLoader.class.getClassLoader().getResourceAsStream(CUSTOM_FUNCTION_LIST_FILE);
                if (in == null) break block8;
                inreader = new InputStreamReader(in);
                reader = new BufferedReader(inreader);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                    CustomFunctionLoader.loadClass(line);
                }
            }
            catch (Throwable e) {
                try {
                    CustomFunctionLoader.error("Load aviator custom functions config from " + CUSTOM_FUNCTION_LIST_FILE + " failed.");
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    CustomFunctionLoader.closeQuietly(reader);
                    CustomFunctionLoader.closeQuietly(inreader);
                    CustomFunctionLoader.closeQuietly(in);
                    if (tatalCustomFunctions > 0) {
                        CustomFunctionLoader.info("Total " + tatalCustomFunctions + " custom functions loaded.");
                    }
                    throw throwable;
                }
                CustomFunctionLoader.closeQuietly(reader);
                CustomFunctionLoader.closeQuietly(inreader);
                CustomFunctionLoader.closeQuietly(in);
                if (tatalCustomFunctions > 0) {
                    CustomFunctionLoader.info("Total " + tatalCustomFunctions + " custom functions loaded.");
                }
            }
        }
        CustomFunctionLoader.closeQuietly(reader);
        CustomFunctionLoader.closeQuietly(inreader);
        CustomFunctionLoader.closeQuietly(in);
        if (tatalCustomFunctions > 0) {
            CustomFunctionLoader.info("Total " + tatalCustomFunctions + " custom functions loaded.");
        }
    }

    public static void loadClass(String className) {
        CustomFunctionLoader.info("Loading custom aviator function class: '" + className + "'.");
        try {
            Class<?> clazz = Class.forName(className);
            AviatorFunction func = (AviatorFunction)clazz.newInstance();
            if (func != null) {
                AviatorEvaluator.addFunction(func);
                ++tatalCustomFunctions;
            }
        }
        catch (Throwable e) {
            CustomFunctionLoader.error("Load custom aviator function class: " + className + "' failed with error:" + e.getMessage() + ".");
        }
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static {
        if (CUSTOM_FUNCTION_LIST_FILE == null || CUSTOM_FUNCTION_LIST_FILE.trim().length() == 0) {
            CUSTOM_FUNCTION_LIST_FILE = "aviator_functions.config";
        }
    }
}

