/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import java.math.MathContext;

public enum Options {
    ALWAYS_USE_DOUBLE_AS_DECIMAL,
    OPTIMIZE_LEVEL,
    MATH_CONTEXT,
    TRACE;


    public boolean isValidValue(Object val) {
        switch (this) {
            case ALWAYS_USE_DOUBLE_AS_DECIMAL: 
            case TRACE: {
                return val instanceof Boolean;
            }
            case OPTIMIZE_LEVEL: {
                return val instanceof Integer && ((Integer)val == 1 || (Integer)val == 0);
            }
            case MATH_CONTEXT: {
                return val instanceof MathContext;
            }
        }
        return false;
    }

    public Object getDefaultValue() {
        switch (this) {
            case ALWAYS_USE_DOUBLE_AS_DECIMAL: {
                return false;
            }
            case OPTIMIZE_LEVEL: {
                return 1;
            }
            case MATH_CONTEXT: {
                return MathContext.DECIMAL128;
            }
            case TRACE: {
                return Boolean.valueOf(System.getProperty("aviator.asm.trace", "false"));
            }
        }
        return null;
    }
}

