/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.LiteralExpression;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.code.asm.ASMCodeGenerator;
import com.googlecode.aviator.lexer.token.AbstractToken;
import com.googlecode.aviator.lexer.token.DelegateToken;
import com.googlecode.aviator.lexer.token.NumberToken;
import com.googlecode.aviator.lexer.token.OperatorToken;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.lexer.token.PatternToken;
import com.googlecode.aviator.lexer.token.StringToken;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorPattern;
import com.googlecode.aviator.runtime.type.AviatorString;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OptimizeCodeGenerator
implements CodeGenerator {
    private final ASMCodeGenerator asmCodeGenerator;
    private final List<Token<?>> tokenList = new ArrayList();
    private boolean trace = false;

    public OptimizeCodeGenerator(ClassLoader classLoader, OutputStream traceOutStream, boolean trace) {
        this.asmCodeGenerator = new ASMCodeGenerator(AviatorEvaluator.getAviatorClassLoader(), traceOutStream, trace);
        this.trace = trace;
    }

    private Map<Integer, DelegateToken.DelegateTokenType> getIndex2DelegateTypeMap(OperatorType opType) {
        HashMap<Integer, DelegateToken.DelegateTokenType> result = new HashMap<Integer, DelegateToken.DelegateTokenType>();
        switch (opType) {
            case AND: {
                result.put(2, DelegateToken.DelegateTokenType.And_Left);
                break;
            }
            case OR: {
                result.put(2, DelegateToken.DelegateTokenType.Join_Left);
                break;
            }
            case TERNARY: {
                result.put(4, DelegateToken.DelegateTokenType.Ternary_Boolean);
                result.put(2, DelegateToken.DelegateTokenType.Ternary_Left);
            }
        }
        return result;
    }

    private int execute() {
        int exeCount = 0;
        int size = this.tokenList.size();
        this.printTokenList();
        block3: for (int i = 0; i < size; ++i) {
            Token<?> token = this.tokenList.get(i);
            if (token.getType() != Token.TokenType.Operator) continue;
            OperatorToken op = (OperatorToken)token;
            OperatorType operatorType = op.getOperatorType();
            int operandCount = operatorType.getOperandCount();
            switch (operatorType) {
                case FUNC: 
                case INDEX: {
                    continue block3;
                }
                default: {
                    Map<Integer, DelegateToken.DelegateTokenType> index2DelegateType = this.getIndex2DelegateTypeMap(operatorType);
                    int result = this.executeOperator(i, operatorType, operandCount, index2DelegateType);
                    if (result < 0) {
                        this.compactTokenList();
                        return exeCount;
                    }
                    exeCount += result;
                }
            }
        }
        this.compactTokenList();
        return exeCount;
    }

    private int executeOperator(int operatorIndex, OperatorType operatorType, int operandCount, Map<Integer, DelegateToken.DelegateTokenType> index2DelegateType) {
        Token<?> token = null;
        operandCount += index2DelegateType.size();
        boolean canExecute = true;
        int count = 0;
        int operandStartIndex = -1;
        for (int j = operatorIndex - 1; j >= 0; --j) {
            token = this.tokenList.get(j);
            if (token == null) {
                return -1;
            }
            Token.TokenType tokenType = token.getType();
            if (!this.isLiteralOperand(token, tokenType, count + 1, index2DelegateType)) {
                canExecute = false;
                break;
            }
            if (++count != operandCount) continue;
            operandStartIndex = j;
            break;
        }
        if (canExecute) {
            AviatorObject[] args = new AviatorObject[operandCount];
            int index = 0;
            for (int j = operandStartIndex; j < operatorIndex; ++j) {
                token = this.tokenList.get(j);
                if (token.getType() == Token.TokenType.Delegate) {
                    this.tokenList.set(j, null);
                    continue;
                }
                args[index++] = this.getAviatorObjectFromToken(token);
                this.tokenList.set(j, null);
            }
            AviatorObject result = operatorType.eval(args);
            this.tokenList.set(operatorIndex, this.getTokenFromOperand(result));
            return 1;
        }
        return 0;
    }

    private boolean isLiteralOperand(Token<?> token, Token.TokenType tokenType, int index, Map<Integer, DelegateToken.DelegateTokenType> index2DelegateType) {
        switch (tokenType) {
            case Variable: {
                return token == Variable.TRUE || token == Variable.FALSE || token == Variable.NIL;
            }
            case Delegate: {
                DelegateToken.DelegateTokenType targetDelegateTokenType = index2DelegateType.get(index);
                if (targetDelegateTokenType == null) break;
                return targetDelegateTokenType == ((DelegateToken)token).getDelegateTokenType();
            }
            case Char: 
            case Number: 
            case Pattern: 
            case String: {
                return true;
            }
        }
        return false;
    }

    private boolean isLiteralToken(Token<?> token) {
        switch (token.getType()) {
            case Variable: {
                return token == Variable.TRUE || token == Variable.FALSE || token == Variable.NIL;
            }
            case Char: 
            case Number: 
            case Pattern: 
            case String: {
                return true;
            }
        }
        return false;
    }

    private Token<?> getTokenFromOperand(AviatorObject operand) {
        AbstractToken token = null;
        switch (operand.getAviatorType()) {
            case Boolean: {
                token = operand.booleanValue(null) ? Variable.TRUE : Variable.FALSE;
                break;
            }
            case Nil: {
                token = Variable.NIL;
                break;
            }
            case BigInt: 
            case Decimal: 
            case Double: 
            case Long: {
                Number value = (Number)operand.getValue(null);
                token = new NumberToken(value, value.toString());
                break;
            }
            case String: {
                String str = (String)operand.getValue(null);
                token = new StringToken(str, -1);
                break;
            }
            case Pattern: {
                token = new PatternToken(((AviatorPattern)operand).getPattern().pattern(), -1);
            }
        }
        return token;
    }

    private void compactTokenList() {
        Iterator<Token<?>> it = this.tokenList.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
    }

    private AviatorObject getAviatorObjectFromToken(Token<?> lookhead) {
        AviatorObject result = null;
        switch (lookhead.getType()) {
            case Number: {
                NumberToken numberToken = (NumberToken)lookhead;
                Number num = numberToken.getNumber();
                result = AviatorNumber.valueOf(num);
                break;
            }
            case String: {
                result = new AviatorString((String)lookhead.getValue(null));
                break;
            }
            case Pattern: {
                result = new AviatorPattern((String)lookhead.getValue(null));
                break;
            }
            case Variable: {
                if (lookhead == Variable.TRUE) {
                    result = AviatorBoolean.TRUE;
                    break;
                }
                if (lookhead == Variable.FALSE) {
                    result = AviatorBoolean.FALSE;
                    break;
                }
                if (lookhead != Variable.NIL) break;
                result = AviatorNil.NIL;
                break;
            }
            case Char: {
                result = new AviatorString(String.valueOf(lookhead.getValue(null)));
            }
        }
        return result;
    }

    @Override
    public Expression getResult() {
        while (this.execute() > 0) {
        }
        LinkedHashMap<String, Integer> variables = new LinkedHashMap<String, Integer>();
        HashMap<String, Integer> methods = new HashMap<String, Integer>();
        block5: for (Token<?> token : this.tokenList) {
            switch (token.getType()) {
                case Variable: {
                    String varName = token.getLexeme();
                    if (!variables.containsKey(varName)) {
                        variables.put(varName, 1);
                        break;
                    }
                    variables.put(varName, (Integer)variables.get(varName) + 1);
                    break;
                }
                case Delegate: {
                    Token<?> realToken;
                    DelegateToken delegateToken = (DelegateToken)token;
                    if (delegateToken.getDelegateTokenType() == DelegateToken.DelegateTokenType.Method_Name) {
                        realToken = delegateToken.getToken();
                        if (realToken.getType() != Token.TokenType.Variable) continue block5;
                        String methodName = token.getLexeme();
                        if (!methods.containsKey(methodName)) {
                            methods.put(methodName, 1);
                            break;
                        }
                        methods.put(methodName, (Integer)methods.get(methodName) + 1);
                        break;
                    }
                    if (delegateToken.getDelegateTokenType() != DelegateToken.DelegateTokenType.Array || (realToken = delegateToken.getToken()).getType() != Token.TokenType.Variable) break;
                    String varName = token.getLexeme();
                    if (!variables.containsKey(varName)) {
                        variables.put(varName, 1);
                        break;
                    }
                    variables.put(varName, (Integer)variables.get(varName) + 1);
                }
            }
        }
        this.callASM(variables, methods);
        if (this.tokenList.size() <= 1) {
            if (this.tokenList.isEmpty()) {
                return new LiteralExpression(null, new ArrayList<String>(variables.keySet()));
            }
            Token<?> lastToken = this.tokenList.get(0);
            if (this.isLiteralToken(lastToken)) {
                return new LiteralExpression(this.getAviatorObjectFromToken(lastToken).getValue(null), new ArrayList<String>(variables.keySet()));
            }
        }
        return this.asmCodeGenerator.getResult();
    }

    private void callASM(Map<String, Integer> variables, Map<String, Integer> methods) {
        this.asmCodeGenerator.initVariables(variables);
        this.asmCodeGenerator.initMethods(methods);
        this.asmCodeGenerator.start();
        block42: for (int i = 0; i < this.tokenList.size(); ++i) {
            Token<?> token = this.tokenList.get(i);
            switch (token.getType()) {
                case Operator: {
                    OperatorToken op = (OperatorToken)token;
                    switch (op.getOperatorType()) {
                        case ADD: {
                            this.asmCodeGenerator.onAdd(token);
                            break;
                        }
                        case SUB: {
                            this.asmCodeGenerator.onSub(token);
                            break;
                        }
                        case MULT: {
                            this.asmCodeGenerator.onMult(token);
                            break;
                        }
                        case DIV: {
                            this.asmCodeGenerator.onDiv(token);
                            break;
                        }
                        case MOD: {
                            this.asmCodeGenerator.onMod(token);
                            break;
                        }
                        case EQ: {
                            this.asmCodeGenerator.onEq(token);
                            break;
                        }
                        case NEQ: {
                            this.asmCodeGenerator.onNeq(token);
                            break;
                        }
                        case LT: {
                            this.asmCodeGenerator.onLt(token);
                            break;
                        }
                        case LE: {
                            this.asmCodeGenerator.onLe(token);
                            break;
                        }
                        case GT: {
                            this.asmCodeGenerator.onGt(token);
                            break;
                        }
                        case GE: {
                            this.asmCodeGenerator.onGe(token);
                            break;
                        }
                        case NOT: {
                            this.asmCodeGenerator.onNot(token);
                            break;
                        }
                        case NEG: {
                            this.asmCodeGenerator.onNeg(token);
                            break;
                        }
                        case AND: {
                            this.asmCodeGenerator.onAndRight(token);
                            break;
                        }
                        case OR: {
                            this.asmCodeGenerator.onJoinRight(token);
                            break;
                        }
                        case FUNC: {
                            this.asmCodeGenerator.onMethodInvoke(token);
                            break;
                        }
                        case INDEX: {
                            this.asmCodeGenerator.onArrayIndexEnd(token);
                            break;
                        }
                        case MATCH: {
                            this.asmCodeGenerator.onMatch(token);
                            break;
                        }
                        case TERNARY: {
                            this.asmCodeGenerator.onTernaryRight(token);
                            break;
                        }
                        case BIT_AND: {
                            this.asmCodeGenerator.onBitAnd(token);
                            break;
                        }
                        case BIT_OR: {
                            this.asmCodeGenerator.onBitOr(token);
                            break;
                        }
                        case BIT_XOR: {
                            this.asmCodeGenerator.onBitXor(token);
                            break;
                        }
                        case BIT_NOT: {
                            this.asmCodeGenerator.onBitNot(token);
                            break;
                        }
                        case SHIFT_LEFT: {
                            this.asmCodeGenerator.onShiftLeft(token);
                            break;
                        }
                        case SHIFT_RIGHT: {
                            this.asmCodeGenerator.onShiftRight(token);
                            break;
                        }
                        case U_SHIFT_RIGHT: {
                            this.asmCodeGenerator.onUnsignedShiftRight(token);
                        }
                    }
                    continue block42;
                }
                case Delegate: {
                    DelegateToken delegateToken = (DelegateToken)token;
                    Token<?> realToken = delegateToken.getToken();
                    switch (delegateToken.getDelegateTokenType()) {
                        case And_Left: {
                            this.asmCodeGenerator.onAndLeft(realToken);
                            break;
                        }
                        case Join_Left: {
                            this.asmCodeGenerator.onJoinLeft(realToken);
                            break;
                        }
                        case Array: {
                            this.asmCodeGenerator.onArray(realToken);
                            break;
                        }
                        case Index_Start: {
                            this.asmCodeGenerator.onArrayIndexStart(realToken);
                            break;
                        }
                        case Ternary_Boolean: {
                            this.asmCodeGenerator.onTernaryBoolean(realToken);
                            break;
                        }
                        case Ternary_Left: {
                            this.asmCodeGenerator.onTernaryLeft(realToken);
                            break;
                        }
                        case Method_Name: {
                            this.asmCodeGenerator.onMethodName(realToken);
                            break;
                        }
                        case Method_Param: {
                            this.asmCodeGenerator.onMethodParameter(realToken);
                        }
                    }
                    continue block42;
                }
                default: {
                    this.asmCodeGenerator.onConstant(token);
                }
            }
        }
    }

    private void printTokenList() {
        if (this.trace) {
            for (Token<?> t : this.tokenList) {
                System.out.print(t.getLexeme() + " ");
            }
            System.out.println();
        }
    }

    @Override
    public void onAdd(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.ADD));
    }

    @Override
    public void onAndLeft(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead == null ? -1 : lookhead.getStartIndex(), lookhead, DelegateToken.DelegateTokenType.And_Left));
    }

    @Override
    public void onAndRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.AND));
    }

    @Override
    public void onConstant(Token<?> lookhead) {
        this.tokenList.add(lookhead);
    }

    @Override
    public void onDiv(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.DIV));
    }

    @Override
    public void onArrayIndexStart(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead == null ? -1 : lookhead.getStartIndex(), lookhead, DelegateToken.DelegateTokenType.Index_Start));
    }

    @Override
    public void onArrayIndexEnd(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.INDEX));
    }

    @Override
    public void onArray(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead == null ? -1 : lookhead.getStartIndex(), lookhead, DelegateToken.DelegateTokenType.Array));
    }

    @Override
    public void onEq(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.EQ));
    }

    @Override
    public void onGe(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.GE));
    }

    @Override
    public void onGt(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.GT));
    }

    @Override
    public void onJoinLeft(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead == null ? -1 : lookhead.getStartIndex(), lookhead, DelegateToken.DelegateTokenType.Join_Left));
    }

    @Override
    public void onJoinRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.OR));
    }

    @Override
    public void onLe(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.LE));
    }

    @Override
    public void onLt(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.LT));
    }

    @Override
    public void onMatch(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.MATCH));
    }

    @Override
    public void onMethodInvoke(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.FUNC));
    }

    @Override
    public void onMethodName(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead == null ? -1 : lookhead.getStartIndex(), lookhead, DelegateToken.DelegateTokenType.Method_Name));
    }

    @Override
    public void onMethodParameter(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead == null ? -1 : lookhead.getStartIndex(), lookhead, DelegateToken.DelegateTokenType.Method_Param));
    }

    @Override
    public void onMod(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.MOD));
    }

    @Override
    public void onMult(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.MULT));
    }

    @Override
    public void onNeg(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.NEG));
    }

    @Override
    public void onNeq(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.NEQ));
    }

    @Override
    public void onNot(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.NOT));
    }

    @Override
    public void onSub(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.SUB));
    }

    @Override
    public void onTernaryBoolean(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead == null ? -1 : lookhead.getStartIndex(), lookhead, DelegateToken.DelegateTokenType.Ternary_Boolean));
    }

    @Override
    public void onTernaryLeft(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead == null ? -1 : lookhead.getStartIndex(), lookhead, DelegateToken.DelegateTokenType.Ternary_Left));
    }

    @Override
    public void onTernaryRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.TERNARY));
    }

    @Override
    public void onBitAnd(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.BIT_AND));
    }

    @Override
    public void onBitNot(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.BIT_NOT));
    }

    @Override
    public void onBitOr(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.BIT_OR));
    }

    @Override
    public void onShiftLeft(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.SHIFT_LEFT));
    }

    @Override
    public void onShiftRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.SHIFT_RIGHT));
    }

    @Override
    public void onUnsignedShiftRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.U_SHIFT_RIGHT));
    }

    @Override
    public void onBitXor(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead == null ? -1 : lookhead.getStartIndex(), OperatorType.BIT_XOR));
    }
}

