/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.lexer;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.CharToken;
import com.googlecode.aviator.lexer.token.NumberToken;
import com.googlecode.aviator.lexer.token.StringToken;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Stack;

public class ExpressionLexer {
    private char peek;
    private final CharacterIterator iterator;
    private final SymbolTable symbolTable;
    private final Stack<Token<?>> tokenBuffer = new Stack();
    static final char[] VALID_HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'a', 'B', 'b', 'C', 'c', 'D', 'd', 'E', 'e', 'F', 'f'};
    static final char[] OPS = new char[]{'=', '>', '<', '+', '-', '*', '/', '%', '!', '&', '|'};

    public ExpressionLexer(String expression) {
        this.iterator = new StringCharacterIterator(expression);
        this.symbolTable = new SymbolTable();
        this.peek = this.iterator.current();
    }

    public void pushback(Token<?> token) {
        this.tokenBuffer.push(token);
    }

    public Token<?> scan() {
        return this.scan(true);
    }

    public void nextChar() {
        this.peek = this.iterator.next();
    }

    public void prevChar() {
        this.peek = this.iterator.previous();
    }

    public boolean isValidHexChar(char ch) {
        for (char c : VALID_HEX_CHAR) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public int getCurrentIndex() {
        return this.iterator.getIndex();
    }

    public Token<?> scan(boolean analyse) {
        if (!this.tokenBuffer.isEmpty()) {
            return this.tokenBuffer.pop();
        }
        while (true) {
            if (this.peek == '\uffff') {
                return null;
            }
            if (analyse) {
                if (this.peek != ' ' && this.peek != '\t' && this.peek != '\r') {
                    if (this.peek != '\n') break;
                    throw new CompileExpressionErrorException("Aviator doesn't support multi-lines expression at " + this.iterator.getIndex());
                }
            } else {
                char ch = this.peek;
                int index = this.iterator.getIndex();
                this.nextChar();
                return new CharToken(ch, index);
            }
            this.nextChar();
        }
        if (Character.isDigit(this.peek) && this.peek == '0') {
            this.nextChar();
            if (this.peek == 'x' || this.peek == 'X') {
                this.nextChar();
                StringBuffer sb = new StringBuffer();
                int startIndex = this.iterator.getIndex() - 2;
                long value = 0L;
                do {
                    sb.append(this.peek);
                    value = 16L * value + (long)Character.digit(this.peek, 16);
                    this.nextChar();
                } while (this.isValidHexChar(this.peek));
                return new NumberToken(value, sb.toString(), startIndex);
            }
            this.prevChar();
        }
        if (Character.isDigit(this.peek) || this.peek == '.') {
            boolean alwaysUseDecimalAsDouble;
            StringBuffer sb = new StringBuffer();
            int startIndex = this.iterator.getIndex();
            long lval = 0L;
            double dval = 0.0;
            boolean hasDot = false;
            double d = 10.0;
            boolean isBigInt = false;
            boolean isBigDecimal = false;
            boolean scientificNotation = false;
            boolean negExp = false;
            do {
                sb.append(this.peek);
                if (this.peek == '.') {
                    if (scientificNotation) {
                        throw new CompileExpressionErrorException("Illegal number " + sb + " at " + this.iterator.getIndex());
                    }
                    if (hasDot) {
                        throw new CompileExpressionErrorException("Illegal Number " + sb + " at " + this.iterator.getIndex());
                    }
                    hasDot = true;
                    this.nextChar();
                    continue;
                }
                if (this.peek == 'N') {
                    if (hasDot) {
                        throw new CompileExpressionErrorException("Illegal number " + sb + " at " + this.iterator.getIndex());
                    }
                    isBigInt = true;
                    this.nextChar();
                    break;
                }
                if (this.peek == 'M') {
                    isBigDecimal = true;
                    this.nextChar();
                    break;
                }
                if (this.peek == 'e' || this.peek == 'E') {
                    if (scientificNotation) {
                        throw new CompileExpressionErrorException("Illegal number " + sb + " at " + this.iterator.getIndex());
                    }
                    scientificNotation = true;
                    this.nextChar();
                    if (this.peek != '-') continue;
                    negExp = true;
                    sb.append(this.peek);
                    this.nextChar();
                    continue;
                }
                int digit = Character.digit(this.peek, 10);
                if (scientificNotation) {
                    int n = digit;
                    this.nextChar();
                    while (Character.isDigit(this.peek)) {
                        n = 10 * n + Character.digit(this.peek, 10);
                        this.nextChar();
                    }
                    while (n-- > 0) {
                        if (negExp) {
                            dval /= 10.0;
                            continue;
                        }
                        dval = 10.0 * dval;
                    }
                    hasDot = true;
                    continue;
                }
                if (hasDot) {
                    dval += (double)digit / d;
                    d *= 10.0;
                    this.nextChar();
                    continue;
                }
                lval = 10L * lval + (long)digit;
                dval = 10.0 * dval + (double)digit;
                this.nextChar();
            } while (Character.isDigit(this.peek) || this.peek == '.' || this.peek == 'E' || this.peek == 'e' || this.peek == 'M' || this.peek == 'N');
            Number value = isBigDecimal ? new BigDecimal(this.getBigNumberLexeme(sb), (MathContext)AviatorEvaluator.getOption(Options.MATH_CONTEXT)) : (isBigInt ? new BigInteger(this.getBigNumberLexeme(sb)) : (hasDot ? (Number)((alwaysUseDecimalAsDouble = ((Boolean)AviatorEvaluator.getOption(Options.ALWAYS_USE_DOUBLE_AS_DECIMAL)).booleanValue()) ? new BigDecimal(sb.toString(), (MathContext)AviatorEvaluator.getOption(Options.MATH_CONTEXT)) : Double.valueOf(dval)) : (Number)(lval < 0L ? new BigInteger(sb.toString()) : Long.valueOf(lval))));
            String lexeme = sb.toString();
            if (isBigDecimal || isBigInt) {
                lexeme = lexeme.substring(0, lexeme.length() - 1);
            }
            return new NumberToken(value, lexeme, startIndex);
        }
        if (Character.isJavaIdentifierStart(this.peek)) {
            int startIndex = this.iterator.getIndex();
            StringBuilder sb = new StringBuilder();
            do {
                sb.append(this.peek);
                this.nextChar();
            } while (Character.isJavaIdentifierPart(this.peek) || this.peek == '.');
            String lexeme = sb.toString();
            Variable variable = new Variable(lexeme, startIndex);
            if (this.symbolTable.contains(lexeme)) {
                return this.symbolTable.getVariable(lexeme);
            }
            this.symbolTable.reserve(lexeme, variable);
            return variable;
        }
        if (ExpressionLexer.isBinaryOP(this.peek)) {
            CharToken opToken = new CharToken(this.peek, this.iterator.getIndex());
            this.nextChar();
            return opToken;
        }
        if (this.peek == '\"' || this.peek == '\'') {
            char left = this.peek;
            int startIndex = this.iterator.getIndex();
            StringBuilder sb = new StringBuilder();
            while ((this.peek = this.iterator.next()) != left) {
                if (this.peek == '\uffff') {
                    throw new CompileExpressionErrorException("Illegal String " + sb + " at " + startIndex);
                }
                sb.append(this.peek);
            }
            this.nextChar();
            return new StringToken(sb.toString(), startIndex);
        }
        CharToken token = new CharToken(this.peek, this.iterator.getIndex());
        this.nextChar();
        return token;
    }

    private String getBigNumberLexeme(StringBuffer sb) {
        String lexeme = sb.toString();
        lexeme = lexeme.substring(0, lexeme.length() - 1);
        return lexeme;
    }

    public static boolean isBinaryOP(char ch) {
        for (char tmp : OPS) {
            if (tmp != ch) continue;
            return true;
        }
        return false;
    }
}

