/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.lexer.token;

import com.googlecode.aviator.lexer.token.Token;

public abstract class AbstractToken<T>
implements Token<T> {
    private final int startIndex;
    protected final String lexeme;

    public AbstractToken(int startIndex, String lexeme) {
        this.startIndex = startIndex;
        this.lexeme = lexeme;
    }

    @Override
    public String getLexeme() {
        return this.lexeme;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    public String toString() {
        return "[" + this.getType().name() + " " + this.getLexeme() + ",index=" + this.startIndex + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lexeme == null ? 0 : this.lexeme.hashCode());
        result = 31 * result + this.startIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractToken other = (AbstractToken)obj;
        if (this.lexeme == null ? other.lexeme != null : !this.lexeme.equals(other.lexeme)) {
            return false;
        }
        return this.startIndex == other.startIndex;
    }
}

