/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class SeqMapFunction
extends AbstractFunction {
    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Object first = arg1.getValue(env);
        AviatorFunction fun = FunctionUtils.getFunction(arg2, env, 1);
        if (fun == null) {
            throw new ExpressionRuntimeException("There is no function named " + ((AviatorJavaType)arg2).getName());
        }
        if (first == null) {
            throw new NullPointerException("null seq");
        }
        Class<?> clazz = first.getClass();
        if (Collection.class.isAssignableFrom(clazz)) {
            ArrayList<Object> result = null;
            try {
                result = (ArrayList<Object>)clazz.newInstance();
            }
            catch (Throwable t) {
                result = new ArrayList<Object>();
            }
            for (Object obj : (Collection)first) {
                result.add(fun.call(env, new AviatorRuntimeJavaType(obj)).getValue(env));
            }
            return new AviatorRuntimeJavaType(result);
        }
        if (clazz.isArray()) {
            int length = Array.getLength(first);
            Object result = Array.newInstance(Object.class, length);
            int index = 0;
            for (int i = 0; i < length; ++i) {
                Object obj = Array.get(first, i);
                Array.set(result, index++, fun.call(env, new AviatorRuntimeJavaType(obj)).getValue(env));
            }
            return new AviatorRuntimeJavaType(result);
        }
        throw new IllegalArgumentException(arg1.desc(env) + " is not a seq");
    }

    @Override
    public String getName() {
        return "map";
    }
}

