/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.system;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.util.Map;

public class BinaryFunction
extends AbstractFunction {
    private final OperatorType opType;

    public BinaryFunction(OperatorType opType) {
        this.opType = opType;
    }

    @Override
    public String getName() {
        return this.opType.getToken();
    }

    public OperatorType getOpType() {
        return this.opType;
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        AviatorObject left = arg1;
        AviatorObject right = arg2;
        switch (this.opType) {
            case ADD: {
                return left.add(right, env);
            }
            case SUB: {
                return left.sub(right, env);
            }
            case MULT: {
                return left.mult(right, env);
            }
            case DIV: {
                return left.div(right, env);
            }
            case MOD: {
                return left.mod(right, env);
            }
            case NOT: 
            case NEG: {
                return this.throwArity(2);
            }
        }
        throw new ExpressionRuntimeException("Invalid binary operator");
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        AviatorObject left = arg1;
        switch (this.opType) {
            case ADD: 
            case SUB: 
            case MULT: 
            case DIV: 
            case MOD: {
                return this.throwArity(1);
            }
            case NOT: {
                return left.not(env);
            }
            case NEG: {
                return left.neg(env);
            }
        }
        throw new ExpressionRuntimeException("Invalid binary operator");
    }
}

