/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorType;
import java.util.Map;

public class AviatorDouble
extends AviatorNumber {
    public AviatorDouble(Number number) {
        super(number);
    }

    public static AviatorDouble valueOf(double value) {
        return new AviatorDouble(value);
    }

    public static AviatorDouble valueOf(Double value) {
        return new AviatorDouble(value);
    }

    @Override
    public int innerCompare(AviatorNumber other) {
        return Double.compare(this.number.doubleValue(), other.doubleValue());
    }

    @Override
    public AviatorObject neg(Map<String, Object> env) {
        return new AviatorDouble(-this.number.doubleValue());
    }

    @Override
    public AviatorObject innerDiv(AviatorNumber other) {
        return new AviatorDouble(this.number.doubleValue() / other.doubleValue());
    }

    @Override
    public AviatorNumber innerAdd(AviatorNumber other) {
        return new AviatorDouble(this.number.doubleValue() + other.doubleValue());
    }

    @Override
    public AviatorObject innerMod(AviatorNumber other) {
        return new AviatorDouble(this.number.doubleValue() % other.doubleValue());
    }

    @Override
    public AviatorObject innerMult(AviatorNumber other) {
        return new AviatorDouble(this.number.doubleValue() * other.doubleValue());
    }

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.Double;
    }

    @Override
    public AviatorObject innerSub(AviatorNumber other) {
        return new AviatorDouble(this.number.doubleValue() - other.doubleValue());
    }
}

