/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.TypeUtils;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class AviatorJavaType
extends AviatorObject {
    private final String name;

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.JavaType;
    }

    public String getName() {
        return this.name;
    }

    public AviatorJavaType(String name) {
        this.name = name;
    }

    @Override
    public AviatorObject div(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.div(other, env);
                }
                return super.div(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.div(other, env);
                }
                return super.div(other, env);
            }
        }
        return super.div(other, env);
    }

    @Override
    public AviatorObject bitAnd(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.bitAnd(other, env);
                }
                return super.bitAnd(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.bitAnd(other, env);
                }
                return super.bitAnd(other, env);
            }
        }
        return super.bitAnd(other, env);
    }

    @Override
    public AviatorObject bitNot(Map<String, Object> env) {
        Object value = this.getValue(env);
        if (value instanceof Number) {
            return AviatorNumber.valueOf(value).bitNot(env);
        }
        return super.bitNot(env);
    }

    @Override
    public AviatorObject bitOr(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.bitOr(other, env);
                }
                return super.bitOr(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.bitOr(other, env);
                }
                return super.bitOr(other, env);
            }
        }
        return super.bitOr(other, env);
    }

    @Override
    public AviatorObject bitXor(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.bitXor(other, env);
                }
                return super.bitXor(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.bitXor(other, env);
                }
                return super.bitXor(other, env);
            }
        }
        return super.bitXor(other, env);
    }

    @Override
    public AviatorObject shiftLeft(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.shiftLeft(other, env);
                }
                return super.shiftLeft(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.shiftLeft(other, env);
                }
                return super.shiftLeft(other, env);
            }
        }
        return super.shiftLeft(other, env);
    }

    @Override
    public AviatorObject shiftRight(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.shiftRight(other, env);
                }
                return super.shiftRight(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.shiftRight(other, env);
                }
                return super.shiftRight(other, env);
            }
        }
        return super.shiftRight(other, env);
    }

    @Override
    public AviatorObject unsignedShiftRight(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.unsignedShiftRight(other, env);
                }
                return super.unsignedShiftRight(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.unsignedShiftRight(other, env);
                }
                return super.unsignedShiftRight(other, env);
            }
        }
        return super.unsignedShiftRight(other, env);
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        try {
            if (env != null) {
                if (this.name.contains(".")) {
                    return PropertyUtils.getProperty(env, (String)this.name);
                }
                return env.get(this.name);
            }
            return null;
        }
        catch (Throwable t) {
            throw new ExpressionRuntimeException("Could not find variable " + this.name, t);
        }
    }

    @Override
    public AviatorObject mod(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.mod(other, env);
                }
                return super.mod(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.mod(other, env);
                }
                return super.mod(other, env);
            }
        }
        return super.mod(other, env);
    }

    @Override
    public AviatorObject sub(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.sub(other, env);
                }
                return super.sub(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.sub(other, env);
                }
                return super.sub(other, env);
            }
        }
        return super.sub(other, env);
    }

    @Override
    public int compare(AviatorObject other, Map<String, Object> env) {
        if (this == other) {
            return 0;
        }
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                AviatorNumber aviatorNumber = (AviatorNumber)other;
                return -aviatorNumber.compare(this, env);
            }
            case String: {
                AviatorString aviatorString = (AviatorString)other;
                return -aviatorString.compare(this, env);
            }
            case Boolean: {
                AviatorBoolean aviatorBoolean = (AviatorBoolean)other;
                return -aviatorBoolean.compare(this, env);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object thisValue = this.getValue(env);
                Object otherValue = otherJavaType.getValue(env);
                if (thisValue == null) {
                    return AviatorNil.NIL.compare(other, env);
                }
                if (thisValue.equals(otherValue)) {
                    return 0;
                }
                if (thisValue instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(thisValue);
                    return thisAviatorNumber.compare(other, env);
                }
                if (TypeUtils.isString(thisValue)) {
                    AviatorString thisAviatorString = new AviatorString(String.valueOf(thisValue));
                    return thisAviatorString.compare(other, env);
                }
                if (thisValue instanceof Boolean) {
                    AviatorBoolean thisAviatorBoolean = AviatorBoolean.valueOf((Boolean)thisValue);
                    return thisAviatorBoolean.compare(other, env);
                }
                if (thisValue instanceof Date && otherValue instanceof String) {
                    return this.tryCompareDate(thisValue, otherValue);
                }
                try {
                    return ((Comparable)thisValue).compareTo(otherValue);
                }
                catch (Throwable t) {
                    throw new ExpressionRuntimeException("Compare " + this + " with " + other + " error", t);
                }
            }
            case Nil: {
                if (this.getValue(env) == null) {
                    return 0;
                }
                return 1;
            }
        }
        throw new ExpressionRuntimeException("Unknow aviator type");
    }

    private int tryCompareDate(Object thisValue, Object otherValue) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
            Date otherDate = simpleDateFormat.parse((String)otherValue);
            return ((Date)thisValue).compareTo(otherDate);
        }
        catch (Throwable t) {
            throw new ExpressionRuntimeException("Compare date error", t);
        }
    }

    @Override
    public AviatorObject mult(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                if (value instanceof Number) {
                    AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
                    return aviatorNumber.mult(other, env);
                }
                return super.mult(other, env);
            }
            case JavaType: {
                if (value instanceof Number) {
                    AviatorNumber thisAviatorNumber = AviatorNumber.valueOf(value);
                    return thisAviatorNumber.mult(other, env);
                }
                return super.mult(other, env);
            }
        }
        return super.mult(other, env);
    }

    @Override
    public AviatorObject neg(Map<String, Object> env) {
        Object value = this.getValue(env);
        if (value instanceof Number) {
            return AviatorNumber.valueOf(value).neg(env);
        }
        return super.neg(env);
    }

    @Override
    public AviatorObject not(Map<String, Object> env) {
        Object value = this.getValue(env);
        if (value instanceof Boolean) {
            return AviatorBoolean.valueOf((Boolean)value).not(env);
        }
        return super.not(env);
    }

    @Override
    public AviatorObject getElement(Map<String, Object> env, AviatorObject indexObject) {
        Object thisValue = this.getValue(env);
        if (!thisValue.getClass().isArray() && !(thisValue instanceof List)) {
            throw new ExpressionRuntimeException(this.desc(env) + " is not a array or list,could not use [] to get element");
        }
        Object indexValue = indexObject.getValue(env);
        if (!this.isInteger(indexValue)) {
            throw new IllegalArgumentException("Illegal index " + indexObject.desc(env));
        }
        int index = ((Number)indexValue).intValue();
        if (thisValue.getClass().isArray()) {
            return new AviatorRuntimeJavaType(Array.get(thisValue, index));
        }
        return new AviatorRuntimeJavaType(((List)thisValue).get(index));
    }

    private boolean isInteger(Object value) {
        return value instanceof Long && (Long)value < Integer.MAX_VALUE || value instanceof Integer || value instanceof Short || value instanceof Byte;
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        Object value = this.getValue(env);
        if (value instanceof Number) {
            AviatorNumber aviatorNumber = AviatorNumber.valueOf(value);
            return aviatorNumber.add(other, env);
        }
        if (TypeUtils.isString(value)) {
            AviatorString aviatorString = new AviatorString(String.valueOf(value));
            return aviatorString.add(other, env);
        }
        if (value instanceof Boolean) {
            return AviatorBoolean.valueOf((Boolean)value).add(other, env);
        }
        return super.add(other, env);
    }
}

