/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.TypeUtils;
import java.util.Map;

public abstract class AviatorObject {
    public abstract int compare(AviatorObject var1, Map<String, Object> var2);

    public abstract AviatorType getAviatorType();

    public boolean isNull(Map<String, Object> env) {
        return this.getValue(env) == null;
    }

    public AviatorObject match(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException(this.desc(env) + " doesn't support match operation '=~'");
    }

    public AviatorObject neg(Map<String, Object> env) {
        throw new ExpressionRuntimeException(this.desc(env) + " doesn't support negative operation '-'");
    }

    public AviatorObject not(Map<String, Object> env) {
        throw new ExpressionRuntimeException(this.desc(env) + " doesn't support not operation '!'");
    }

    public String desc(Map<String, Object> env) {
        return (Object)((Object)this.getAviatorType()) + "(" + this.getValue(env) + ")";
    }

    public abstract Object getValue(Map<String, Object> var1);

    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not add " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject bitAnd(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not bitAnd " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject bitOr(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not bitOr " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject bitXor(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not bitXor " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject shiftRight(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not shiftRight " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject shiftLeft(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not shiftLeft " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject unsignedShiftRight(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not unsignedShiftRight " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject bitNot(Map<String, Object> env) {
        throw new ExpressionRuntimeException(this.desc(env) + " doesn't support not operation '^'");
    }

    public AviatorObject sub(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not sub " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject mod(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not mod " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject div(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not div " + this.desc(env) + " with " + other.desc(env));
    }

    public AviatorObject mult(AviatorObject other, Map<String, Object> env) {
        throw new ExpressionRuntimeException("Could not mult " + this.desc(env) + " with " + other.desc(env));
    }

    public Number numberValue(Map<String, Object> env) {
        if (!(this.getValue(env) instanceof Number)) {
            throw new ExpressionRuntimeException(this.desc(env) + " is not a number value");
        }
        return (Number)this.getValue(env);
    }

    public String stringValue(Map<String, Object> env) {
        Object value = this.getValue(env);
        if (!TypeUtils.isString(value)) {
            throw new ExpressionRuntimeException(this.desc(env) + " is not a string value");
        }
        return String.valueOf(value);
    }

    public boolean booleanValue(Map<String, Object> env) {
        if (!(this.getValue(env) instanceof Boolean)) {
            throw new ExpressionRuntimeException(this.desc(env) + " is not a boolean value");
        }
        return (Boolean)this.getValue(env);
    }

    public AviatorObject getElement(Map<String, Object> env, AviatorObject indexObject) {
        throw new ExpressionRuntimeException(this.desc(env) + " is not a array");
    }
}

