/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XmlFormat {
    private static final int BUFFER_SIZE = 4096;

    public static void print(Message message, Appendable output) throws IOException {
        XmlGenerator generator = new XmlGenerator(output);
        String messageName = message.getDescriptorForType().getName();
        generator.print("<");
        generator.print(messageName);
        generator.print(">");
        XmlFormat.print(message, generator);
        generator.print("</");
        generator.print(messageName);
        generator.print(">");
    }

    public static void print(UnknownFieldSet fields, Appendable output) throws IOException {
        XmlGenerator generator = new XmlGenerator(output);
        generator.print("<message>");
        XmlFormat.printUnknownFields(fields, generator);
        generator.print("</message>");
    }

    public static String printToString(Message message) {
        try {
            StringBuilder text = new StringBuilder();
            XmlFormat.print(message, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", e);
        }
    }

    public static String printToString(UnknownFieldSet fields) {
        try {
            StringBuilder text = new StringBuilder();
            XmlFormat.print(fields, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", e);
        }
    }

    private static void print(Message message, XmlGenerator generator) throws IOException {
        for (Map.Entry field : message.getAllFields().entrySet()) {
            XmlFormat.printField((Descriptors.FieldDescriptor)field.getKey(), field.getValue(), generator);
        }
        XmlFormat.printUnknownFields(message.getUnknownFields(), generator);
    }

    public static void printField(Descriptors.FieldDescriptor field, Object value, XmlGenerator generator) throws IOException {
        if (field.isRepeated()) {
            for (Object element : (List)value) {
                XmlFormat.printSingleField(field, element, generator);
            }
        } else {
            XmlFormat.printSingleField(field, value, generator);
        }
    }

    private static void printSingleField(Descriptors.FieldDescriptor field, Object value, XmlGenerator generator) throws IOException {
        if (field.isExtension()) {
            generator.print("<extension type=\"");
            if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                generator.print(field.getMessageType().getFullName());
            } else {
                generator.print(field.getFullName());
            }
            generator.print("\">");
        } else {
            generator.print("<");
            if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            generator.print(">");
        }
        XmlFormat.printFieldValue(field, value, generator);
        if (!field.isExtension()) {
            generator.print("</");
            if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            generator.print(">");
        } else {
            generator.print("</extension>");
        }
    }

    private static void printFieldValue(Descriptors.FieldDescriptor field, Object value, XmlGenerator generator) throws IOException {
        switch (field.getType()) {
            case INT32: 
            case INT64: 
            case SINT32: 
            case SINT64: 
            case SFIXED32: 
            case SFIXED64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOL: {
                generator.print(value.toString());
                break;
            }
            case UINT32: 
            case FIXED32: {
                generator.print(XmlFormat.unsignedToString((Integer)value));
                break;
            }
            case UINT64: 
            case FIXED64: {
                generator.print(XmlFormat.unsignedToString((Long)value));
                break;
            }
            case STRING: {
                generator.print(XmlFormat.escapeText((String)value));
                break;
            }
            case BYTES: {
                generator.print(XmlFormat.escapeBytes((ByteString)value));
                break;
            }
            case ENUM: {
                generator.print(((Descriptors.EnumValueDescriptor)value).getName());
                break;
            }
            case MESSAGE: 
            case GROUP: {
                XmlFormat.print((Message)value, generator);
            }
        }
    }

    private static void printUnknownFields(UnknownFieldSet unknownFields, XmlGenerator generator) throws IOException {
        for (Map.Entry entry : unknownFields.asMap().entrySet()) {
            UnknownFieldSet.Field field = (UnknownFieldSet.Field)entry.getValue();
            String key = ((Integer)entry.getKey()).toString();
            Iterator i$ = field.getVarintList().iterator();
            while (i$.hasNext()) {
                long value = (Long)i$.next();
                XmlFormat.printUnknownField(key, XmlFormat.unsignedToString(value), generator);
            }
            i$ = field.getFixed32List().iterator();
            while (i$.hasNext()) {
                int value = (Integer)i$.next();
                XmlFormat.printUnknownField(key, String.format((Locale)null, "0x%08x", value), generator);
            }
            i$ = field.getFixed64List().iterator();
            while (i$.hasNext()) {
                long value = (Long)i$.next();
                XmlFormat.printUnknownField(key, String.format((Locale)null, "0x%016x", value), generator);
            }
            for (ByteString value : field.getLengthDelimitedList()) {
                XmlFormat.printUnknownField(key, XmlFormat.escapeBytes(value), generator);
            }
            for (UnknownFieldSet value : field.getGroupList()) {
                generator.print("<unknown-field index=\"");
                generator.print(key);
                generator.print("\">");
                XmlFormat.printUnknownFields(value, generator);
                generator.print("</unknown-field>");
            }
        }
    }

    private static void printUnknownField(CharSequence fieldKey, CharSequence fieldValue, XmlGenerator generator) throws IOException {
        generator.print("<unknown-field index=\"");
        generator.print(fieldKey);
        generator.print("\">");
        generator.print(fieldValue);
        generator.print("</unknown-field>");
    }

    private static String unsignedToString(int value) {
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)value & 0xFFFFFFFFL);
    }

    private static String unsignedToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    public static void merge(Readable input, Message.Builder builder) throws ParseException, IOException {
        XmlFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(CharSequence input, Message.Builder builder) throws ParseException {
        XmlFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException, IOException {
        XmlFormat.merge(XmlFormat.toStringBuilder(input), extensionRegistry, builder);
    }

    private static StringBuilder toStringBuilder(Readable input) throws IOException {
        int n;
        StringBuilder text = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(4096);
        while ((n = input.read(buffer)) != -1) {
            buffer.flip();
            text.append(buffer, 0, n);
        }
        return text;
    }

    public static void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(input);
        XmlFormat.consumeOpeningElement(tokenizer);
        while (!tokenizer.tryConsume("</")) {
            XmlFormat.mergeField(tokenizer, extensionRegistry, builder);
        }
        XmlFormat.consumeClosingElement(tokenizer);
    }

    private static String consumeOpeningElement(Tokenizer tokenizer) throws ParseException {
        tokenizer.consume("<");
        String openingElement = tokenizer.consumeIdentifier();
        tokenizer.consume(">");
        return openingElement;
    }

    private static void consumeClosingElement(Tokenizer tokenizer) throws ParseException {
        tokenizer.tryConsume("</");
        tokenizer.nextToken();
        tokenizer.consume(">");
    }

    private static String consumeExtensionIdentifier(Tokenizer tokenizer) throws ParseException {
        tokenizer.consume("type");
        tokenizer.consume("=");
        return tokenizer.consumeIdentifier();
    }

    private static void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Descriptors.FieldDescriptor field;
        CharSequence name;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        ExtensionRegistry.ExtensionInfo extension = null;
        tokenizer.consume("<");
        if (tokenizer.tryConsume("extension")) {
            name = new StringBuilder(XmlFormat.consumeExtensionIdentifier(tokenizer));
            while (tokenizer.tryConsume(".")) {
                ((StringBuilder)name).append(".");
                ((StringBuilder)name).append(tokenizer.consumeIdentifier());
            }
            extension = extensionRegistry.findExtensionByName(((StringBuilder)name).toString());
            if (extension == null) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name + "\" not found in the ExtensionRegistry.");
            }
            if (extension.descriptor.getContainingType() != type) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name + "\" does not extend message type \"" + type.getFullName() + "\".");
            }
            field = extension.descriptor;
        } else {
            String lowerName;
            name = tokenizer.consumeIdentifier();
            field = type.findFieldByName((String)name);
            if (field == null && (field = type.findFieldByName(lowerName = ((String)name).toLowerCase(Locale.US))) != null && field.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                field = null;
            }
            if (field != null && field.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field.getMessageType().getName().equals(name)) {
                field = null;
            }
            if (field == null) {
                throw tokenizer.parseExceptionPreviousToken("Message type \"" + type.getFullName() + "\" has no field named \"" + (String)name + "\".");
            }
        }
        tokenizer.consume(">");
        Object value = XmlFormat.handleValue(tokenizer, extensionRegistry, builder, field, extension);
        if (field.isRepeated()) {
            builder.addRepeatedField(field, value);
        } else {
            builder.setField(field, value);
        }
        XmlFormat.consumeClosingElement(tokenizer);
    }

    private static Object handleValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension) throws ParseException {
        Object value = null;
        value = field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? XmlFormat.handleObject(tokenizer, extensionRegistry, builder, field, extension) : XmlFormat.handlePrimitive(tokenizer, field);
        return value;
    }

    private static Object handlePrimitive(Tokenizer tokenizer, Descriptors.FieldDescriptor field) throws ParseException {
        Object value = null;
        switch (field.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                value = tokenizer.consumeInt32();
                break;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                value = tokenizer.consumeInt64();
                break;
            }
            case UINT32: 
            case FIXED32: {
                value = tokenizer.consumeUInt32();
                break;
            }
            case UINT64: 
            case FIXED64: {
                value = tokenizer.consumeUInt64();
                break;
            }
            case FLOAT: {
                value = Float.valueOf(tokenizer.consumeFloat());
                break;
            }
            case DOUBLE: {
                value = tokenizer.consumeDouble();
                break;
            }
            case BOOL: {
                value = tokenizer.consumeBoolean();
                break;
            }
            case STRING: {
                value = tokenizer.consumeString();
                break;
            }
            case BYTES: {
                value = tokenizer.consumeByteString();
                break;
            }
            case ENUM: {
                Descriptors.EnumDescriptor enumType = field.getEnumType();
                if (tokenizer.lookingAtInteger()) {
                    int number = tokenizer.consumeInt32();
                    value = enumType.findValueByNumber(number);
                    if (value != null) break;
                    throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value with number " + number + ".");
                }
                String id = tokenizer.consumeIdentifier();
                value = enumType.findValueByName(id);
                if (value != null) break;
                throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value named \"" + id + "\".");
            }
            case MESSAGE: 
            case GROUP: {
                throw new RuntimeException("Can't get here.");
            }
        }
        return value;
    }

    private static Object handleObject(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension) throws ParseException {
        Message.Builder subBuilder = extension == null ? builder.newBuilderForField(field) : extension.defaultInstance.newBuilderForType();
        String endToken = "</";
        while (!tokenizer.tryConsume(endToken)) {
            if (tokenizer.atEnd()) {
                throw tokenizer.parseException("Expected \"" + endToken + "\".");
            }
            XmlFormat.mergeField(tokenizer, extensionRegistry, subBuilder);
        }
        Message value = subBuilder.build();
        return value;
    }

    static String escapeBytes(ByteString input) {
        StringBuilder builder = new StringBuilder(input.size());
        block12: for (int i = 0; i < input.size(); ++i) {
            byte b = input.byteAt(i);
            switch (b) {
                case 7: {
                    builder.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder.append((char)b);
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append((char)(48 + (b >>> 6 & 3)));
                    builder.append((char)(48 + (b >>> 3 & 7)));
                    builder.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder.toString();
    }

    static ByteString unescapeBytes(CharSequence input) throws InvalidEscapeSequence {
        byte[] result = new byte[input.length()];
        int pos = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                if (i + 1 < input.length()) {
                    int code;
                    if (XmlFormat.isOctal(c = input.charAt(++i))) {
                        code = XmlFormat.digitValue(c);
                        if (i + 1 < input.length() && XmlFormat.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + XmlFormat.digitValue(input.charAt(++i));
                        }
                        if (i + 1 < input.length() && XmlFormat.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + XmlFormat.digitValue(input.charAt(++i));
                        }
                        result[pos++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 'a': {
                            result[pos++] = 7;
                            break;
                        }
                        case 'b': {
                            result[pos++] = 8;
                            break;
                        }
                        case 'f': {
                            result[pos++] = 12;
                            break;
                        }
                        case 'n': {
                            result[pos++] = 10;
                            break;
                        }
                        case 'r': {
                            result[pos++] = 13;
                            break;
                        }
                        case 't': {
                            result[pos++] = 9;
                            break;
                        }
                        case 'v': {
                            result[pos++] = 11;
                            break;
                        }
                        case '\\': {
                            result[pos++] = 92;
                            break;
                        }
                        case '\'': {
                            result[pos++] = 39;
                            break;
                        }
                        case '\"': {
                            result[pos++] = 34;
                            break;
                        }
                        case 'x': {
                            code = 0;
                            if (i + 1 >= input.length() || !XmlFormat.isHex(input.charAt(i + 1))) {
                                throw new InvalidEscapeSequence("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = XmlFormat.digitValue(input.charAt(++i));
                            if (i + 1 < input.length() && XmlFormat.isHex(input.charAt(i + 1))) {
                                code = code * 16 + XmlFormat.digitValue(input.charAt(++i));
                            }
                            result[pos++] = (byte)code;
                            break;
                        }
                        default: {
                            throw new InvalidEscapeSequence("Invalid escape sequence: '\\" + c + "'");
                        }
                    }
                    continue;
                }
                throw new InvalidEscapeSequence("Invalid escape sequence: '\\' at end of string.");
            }
            result[pos++] = (byte)c;
        }
        return ByteString.copyFrom((byte[])result, (int)0, (int)pos);
    }

    static String escapeText(String input) {
        return XmlFormat.escapeBytes(ByteString.copyFromUtf8((String)input));
    }

    static String unescapeText(String input) throws InvalidEscapeSequence {
        return XmlFormat.unescapeBytes(input).toStringUtf8();
    }

    private static boolean isOctal(char c) {
        return '0' <= c && c <= '7';
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private static int digitValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'z') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)XmlFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)XmlFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return XmlFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return XmlFormat.parseInteger(text, false, true);
    }

    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text.startsWith("-", pos)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text.substring(pos);
        long result = 0L;
        if (numberText.length() < 16) {
            result = Long.parseLong(numberText, radix);
            if (negative) {
                result = -result;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (result >= 0x100000000L || result < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text);
            }
            result = bigValue.longValue();
        }
        return result;
    }

    static class InvalidEscapeSequence
    extends IOException {
        private static final long serialVersionUID = 1L;

        public InvalidEscapeSequence(String description) {
            super(description);
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ParseException(String message) {
            super(message);
        }
    }

    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("extension|[a-zA-Z_\\s;@][0-9a-zA-Z_\\s;@+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|</|[\\\\0-9]++|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        public Tokenizer(CharSequence text) {
            this.text = text;
            this.matcher = WHITESPACE.matcher(text);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String token) throws ParseException {
            if (!this.tryConsume(token)) {
                throw this.parseException("Expected \"" + token + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '\"') continue;
                throw this.parseException("Expected identifier. -" + c);
            }
            String result = this.currentToken;
            result = result.replaceAll("\"|'", "");
            this.nextToken();
            return result;
        }

        public int consumeInt32() throws ParseException {
            try {
                int result = XmlFormat.parseInt32(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int result = XmlFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long result = XmlFormat.parseInt64(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long result = XmlFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double result = Double.parseDouble(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float result = Float.parseFloat(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public ByteString consumeByteString() throws ParseException {
            try {
                String escaped = this.currentToken;
                ByteString result = XmlFormat.unescapeBytes(escaped);
                this.nextToken();
                return result;
            }
            catch (InvalidEscapeSequence e) {
                throw this.parseException(e.getMessage());
            }
        }

        public ParseException parseException(String description) {
            return new ParseException(this.line + 1 + ":" + (this.column + 1) + ": " + description);
        }

        public ParseException parseExceptionPreviousToken(String description) {
            return new ParseException(this.previousLine + 1 + ":" + (this.previousColumn + 1) + ": " + description);
        }

        private ParseException integerParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse integer: " + e.getMessage());
        }

        private ParseException floatParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse number: " + e.getMessage());
        }
    }

    private static final class XmlGenerator {
        Appendable output;

        public XmlGenerator(Appendable output) {
            this.output = output;
        }

        public void print(CharSequence text) throws IOException {
            int size = text.length();
            int pos = 0;
            this.write(text.subSequence(pos, size), size - pos);
        }

        private void write(CharSequence data, int size) throws IOException {
            if (size == 0) {
                return;
            }
            this.output.append(data);
        }
    }
}

