/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.exception.IronPdfDeploymentException;
import com.ironsoftware.ironpdf.exception.IronPdfInputException;
import com.ironsoftware.ironpdf.exception.IronPdfLicensingException;
import com.ironsoftware.ironpdf.exception.IronPdfNativeException;
import com.ironsoftware.ironpdf.exception.IronPdfProductException;
import com.ironsoftware.ironpdf.internal.proto.RemoteException;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_RemoteException;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;

final class Exception_Converter {
    Exception_Converter() {
    }

    static RuntimeException fromProto(RemoteException exception) {
        String cs;
        Exception_RemoteException ex = new Exception_RemoteException(exception.getMessage(), Utils_Util.nullIfEmpty(exception.getRemoteStackTrace()), Utils_Util.nullIfEmpty(exception.getExceptionType()));
        String[] exceptionTypes = ex.getExceptionType().split("[.]", -1);
        switch (cs = exceptionTypes[exceptionTypes.length - 1]) {
            case "IronPdfDeploymentException": {
                throw new IronPdfDeploymentException(ex);
            }
            case "IronPdfInputException": {
                throw new IronPdfInputException(ex);
            }
            case "IronPdfLicensingException": {
                throw new IronPdfLicensingException(ex);
            }
            case "IronPdfNativeException": {
                throw new IronPdfNativeException(ex);
            }
            case "IronPdfProductException": {
                throw new IronPdfProductException(ex);
            }
            case "NotSupportedException": {
                throw new UnsupportedOperationException(ex.getMessage() + ex.stackTraceString, ex);
            }
            case "IndexOutOfRangeException": 
            case "ArgumentOutOfRangeException": {
                throw new IndexOutOfBoundsException(ex.getMessage() + ex.stackTraceString);
            }
            case "ArgumentException": {
                throw new IllegalArgumentException(ex.getMessage() + ex.stackTraceString, ex);
            }
            case "InvalidCastException": {
                throw new ClassCastException(ex.getMessage() + ex.stackTraceString);
            }
            case "NullReferenceException": {
                throw new NullPointerException(ex.getMessage() + ex.stackTraceString);
            }
        }
        throw ex;
    }
}

