/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.tagging;

import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.properties.CaptionSide;
import com.itextpdf.layout.tagging.ITaggingRule;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import com.itextpdf.layout.tagging.TaggingDummyElement;
import com.itextpdf.layout.tagging.TaggingHintKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

class TableTaggingRule
implements ITaggingRule {
    TableTaggingRule() {
    }

    @Override
    public boolean onTagFinish(LayoutTaggingHelper taggingHelper, TaggingHintKey tableHintKey) {
        List<TaggingHintKey> kidKeys = taggingHelper.getAccessibleKidsHint(tableHintKey);
        TreeMap<Integer, TreeMap<Integer, TaggingHintKey>> tableTags = new TreeMap<Integer, TreeMap<Integer, TaggingHintKey>>();
        ArrayList<TaggingHintKey> tableCellTagsUnindexed = new ArrayList<TaggingHintKey>();
        ArrayList<TaggingHintKey> nonCellKids = new ArrayList<TaggingHintKey>();
        for (TaggingHintKey kidKey : kidKeys) {
            boolean isCell;
            String kidRole = TableTaggingRule.getKidRole(kidKey, taggingHelper);
            boolean bl = isCell = "TD".equals(kidRole) || "TH".equals(kidRole);
            if (isCell && kidKey.getAccessibleElement() instanceof Cell) {
                Cell cell = (Cell)kidKey.getAccessibleElement();
                int rowInd = cell.getRow();
                int colInd = cell.getCol();
                TreeMap<Integer, TaggingHintKey> rowTags = (TreeMap<Integer, TaggingHintKey>)tableTags.get(rowInd);
                if (rowTags == null) {
                    rowTags = new TreeMap<Integer, TaggingHintKey>();
                    tableTags.put(rowInd, rowTags);
                }
                rowTags.put(colInd, kidKey);
                continue;
            }
            if (isCell) {
                tableCellTagsUnindexed.add(kidKey);
                continue;
            }
            nonCellKids.add(kidKey);
        }
        TaggingDummyElement tbodyTag = TableTaggingRule.getTbodyTag(tableHintKey);
        for (TaggingHintKey nonCellKid : nonCellKids) {
            String kidRole = TableTaggingRule.getKidRole(nonCellKid, taggingHelper);
            if ("THead".equals(kidRole) || "TFoot".equals(kidRole) || "Caption".equals(kidRole)) continue;
            taggingHelper.moveKidHint(nonCellKid, tableHintKey);
        }
        for (TaggingHintKey nonCellKid : nonCellKids) {
            if (!"THead".equals(TableTaggingRule.getKidRole(nonCellKid, taggingHelper))) continue;
            taggingHelper.moveKidHint(nonCellKid, tableHintKey);
        }
        taggingHelper.addKidsHint(tableHintKey, Collections.singletonList(LayoutTaggingHelper.getOrCreateHintKey(tbodyTag)), -1);
        for (TaggingHintKey nonCellKid : nonCellKids) {
            if (!"TFoot".equals(TableTaggingRule.getKidRole(nonCellKid, taggingHelper))) continue;
            taggingHelper.moveKidHint(nonCellKid, tableHintKey);
        }
        for (TreeMap rowTags : tableTags.values()) {
            TaggingDummyElement row = new TaggingDummyElement("TR");
            TaggingHintKey rowTagHint = LayoutTaggingHelper.getOrCreateHintKey(row);
            for (TaggingHintKey cellTagHint : rowTags.values()) {
                taggingHelper.moveKidHint(cellTagHint, rowTagHint);
            }
            if (tableCellTagsUnindexed != null) {
                for (TaggingHintKey cellTagHint : tableCellTagsUnindexed) {
                    taggingHelper.moveKidHint(cellTagHint, rowTagHint);
                }
                tableCellTagsUnindexed = null;
            }
            taggingHelper.addKidsHint(tbodyTag, Collections.singletonList(row), -1);
        }
        for (TaggingHintKey nonCellKid : nonCellKids) {
            if (!"Caption".equals(TableTaggingRule.getKidRole(nonCellKid, taggingHelper))) continue;
            TableTaggingRule.moveCaption(taggingHelper, nonCellKid, tableHintKey);
        }
        return true;
    }

    private static String getKidRole(TaggingHintKey kidKey, LayoutTaggingHelper helper) {
        return helper.getPdfDocument().getTagStructureContext().resolveMappingToStandardOrDomainSpecificRole(kidKey.getAccessibilityProperties().getRole(), null).getRole();
    }

    private static TaggingDummyElement getTbodyTag(TaggingHintKey tableHintKey) {
        boolean createTBody = true;
        if (tableHintKey.getAccessibleElement() instanceof Table) {
            Table modelElement = (Table)tableHintKey.getAccessibleElement();
            createTBody = modelElement.getHeader() != null && !modelElement.isSkipFirstHeader() || modelElement.getFooter() != null && !modelElement.isSkipLastFooter();
        }
        return new TaggingDummyElement(createTBody ? "TBody" : null);
    }

    private static void moveCaption(LayoutTaggingHelper taggingHelper, TaggingHintKey caption, TaggingHintKey tableHintKey) {
        if (!(tableHintKey.getAccessibleElement() instanceof Table)) {
            return;
        }
        Table tableElem = (Table)tableHintKey.getAccessibleElement();
        Div captionDiv = tableElem.getCaption();
        if (captionDiv == null) {
            return;
        }
        CaptionSide captionSide = captionDiv.getProperty(119) == null ? CaptionSide.TOP : (CaptionSide)((Object)captionDiv.getProperty(119));
        if (CaptionSide.TOP.equals((Object)captionSide)) {
            taggingHelper.moveKidHint(caption, tableHintKey, 0);
        } else {
            taggingHelper.moveKidHint(caption, tableHintKey);
        }
    }
}

