/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.summer.utils;

import com.itranswarp.summer.utils.ClassPathUtils;
import com.itranswarp.summer.utils.NoImplicitResolver;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlUtils {
    public static Map<String, Object> loadYaml(String path) {
        LoaderOptions loaderOptions = new LoaderOptions();
        DumperOptions dumperOptions = new DumperOptions();
        Representer representer = new Representer(dumperOptions);
        NoImplicitResolver resolver = new NoImplicitResolver();
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(loaderOptions), representer, dumperOptions, loaderOptions, (Resolver)resolver);
        return ClassPathUtils.readInputStream(path, input -> (Map)yaml.load(input));
    }

    public static Map<String, Object> loadYamlAsPlainMap(String path) {
        Map<String, Object> data = YamlUtils.loadYaml(path);
        LinkedHashMap<String, Object> plain = new LinkedHashMap<String, Object>();
        YamlUtils.convertTo(data, "", plain);
        return plain;
    }

    static void convertTo(Map<String, Object> source, String prefix, Map<String, Object> plain) {
        for (String key : source.keySet()) {
            Object value = source.get(key);
            if (value instanceof Map) {
                Map subMap = (Map)value;
                YamlUtils.convertTo(subMap, prefix + key + ".", plain);
                continue;
            }
            if (value instanceof List) {
                plain.put(prefix + key, value);
                continue;
            }
            plain.put(prefix + key, value.toString());
        }
    }
}

