/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.summer.jdbc;

import com.itranswarp.summer.exception.DataAccessException;
import com.itranswarp.summer.jdbc.RowMapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanRowMapper<T>
implements RowMapper<T> {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    Class<T> clazz;
    Constructor<T> constructor;
    Map<String, Field> fields = new HashMap<String, Field>();
    Map<String, Method> methods = new HashMap<String, Method>();

    public BeanRowMapper(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DataAccessException(String.format("No public default constructor found for class %s when build BeanRowMapper.", clazz.getName()), e);
        }
        for (Field field : clazz.getFields()) {
            String name = field.getName();
            this.fields.put(name, field);
            this.logger.atDebug().log("Add row mapping: {} to field {}", (Object)name, (Object)name);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            String name;
            Parameter[] ps = ((Executable)accessibleObject).getParameters();
            if (ps.length != 1 || (name = ((Method)accessibleObject).getName()).length() < 4 || !name.startsWith("set")) continue;
            String prop = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            this.methods.put(prop, (Method)accessibleObject);
            this.logger.atDebug().log("Add row mapping: {} to {}({})", new Object[]{prop, name, ps[0].getType().getSimpleName()});
        }
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        T bean;
        try {
            bean = this.constructor.newInstance(new Object[0]);
            ResultSetMetaData meta = rs.getMetaData();
            int columns = meta.getColumnCount();
            for (int i = 1; i <= columns; ++i) {
                String label = meta.getColumnLabel(i);
                Method method = this.methods.get(label);
                if (method != null) {
                    method.invoke(bean, rs.getObject(label));
                    continue;
                }
                Field field = this.fields.get(label);
                if (field == null) continue;
                field.set(bean, rs.getObject(label));
            }
        }
        catch (ReflectiveOperationException e) {
            throw new DataAccessException(String.format("Could not map result set to class %s", this.clazz.getName()), e);
        }
        return bean;
    }
}

