/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.summer.jdbc;

import com.itranswarp.summer.annotation.Autowired;
import com.itranswarp.summer.annotation.Bean;
import com.itranswarp.summer.annotation.Configuration;
import com.itranswarp.summer.annotation.Value;
import com.itranswarp.summer.jdbc.JdbcTemplate;
import com.itranswarp.summer.jdbc.tx.DataSourceTransactionManager;
import com.itranswarp.summer.jdbc.tx.PlatformTransactionManager;
import com.itranswarp.summer.jdbc.tx.TransactionalBeanPostProcessor;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;

@Configuration
public class JdbcConfiguration {
    @Bean(destroyMethod="close")
    DataSource dataSource(@Value(value="${summer.datasource.url}") String url, @Value(value="${summer.datasource.username}") String username, @Value(value="${summer.datasource.password}") String password, @Value(value="${summer.datasource.driver-class-name:}") String driver, @Value(value="${summer.datasource.maximum-pool-size:20}") int maximumPoolSize, @Value(value="${summer.datasource.minimum-pool-size:1}") int minimumPoolSize, @Value(value="${summer.datasource.connection-timeout:30000}") int connTimeout) {
        HikariConfig config = new HikariConfig();
        config.setAutoCommit(false);
        config.setJdbcUrl(url);
        config.setUsername(username);
        config.setPassword(password);
        if (driver != null) {
            config.setDriverClassName(driver);
        }
        config.setMaximumPoolSize(maximumPoolSize);
        config.setMinimumIdle(minimumPoolSize);
        config.setConnectionTimeout((long)connTimeout);
        return new HikariDataSource(config);
    }

    @Bean
    JdbcTemplate jdbcTemplate(@Autowired DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean
    TransactionalBeanPostProcessor transactionalBeanPostProcessor() {
        return new TransactionalBeanPostProcessor();
    }

    @Bean
    PlatformTransactionManager platformTransactionManager(@Autowired DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

