/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.summer.jdbc;

import com.itranswarp.summer.exception.DataAccessException;
import com.itranswarp.summer.jdbc.BeanRowMapper;
import com.itranswarp.summer.jdbc.BooleanRowMapper;
import com.itranswarp.summer.jdbc.ConnectionCallback;
import com.itranswarp.summer.jdbc.NumberRowMapper;
import com.itranswarp.summer.jdbc.PreparedStatementCallback;
import com.itranswarp.summer.jdbc.PreparedStatementCreator;
import com.itranswarp.summer.jdbc.RowMapper;
import com.itranswarp.summer.jdbc.StringRowMapper;
import com.itranswarp.summer.jdbc.tx.TransactionalUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class JdbcTemplate {
    final DataSource dataSource;

    public JdbcTemplate(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Number queryForNumber(String sql, Object ... args) throws DataAccessException {
        return this.queryForObject(sql, NumberRowMapper.instance, args);
    }

    public <T> T queryForObject(String sql, Class<T> clazz, Object ... args) throws DataAccessException {
        if (clazz == String.class) {
            return (T)this.queryForObject(sql, StringRowMapper.instance, args);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return (T)this.queryForObject(sql, BooleanRowMapper.instance, args);
        }
        if (Number.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
            return (T)this.queryForObject(sql, NumberRowMapper.instance, args);
        }
        return this.queryForObject(sql, new BeanRowMapper<T>(clazz), args);
    }

    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return (T)this.execute(this.preparedStatementCreator(sql, args), ps -> {
            Object t = null;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    if (t == null) {
                        t = rowMapper.mapRow(rs, rs.getRow());
                        continue;
                    }
                    throw new DataAccessException("Multiple rows found.");
                }
            }
            if (t == null) {
                throw new DataAccessException("Empty result set.");
            }
            return t;
        });
    }

    public <T> List<T> queryForList(String sql, Class<T> clazz, Object ... args) throws DataAccessException {
        return this.queryForList(sql, new BeanRowMapper<T>(clazz), args);
    }

    public <T> List<T> queryForList(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.execute(this.preparedStatementCreator(sql, args), ps -> {
            ArrayList list = new ArrayList();
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(rowMapper.mapRow(rs, rs.getRow()));
                }
            }
            return list;
        });
    }

    public Number updateAndReturnGeneratedKey(String sql, Object ... args) throws DataAccessException {
        return this.execute(con -> {
            PreparedStatement ps = con.prepareStatement(sql, 1);
            this.bindArgs(ps, args);
            return ps;
        }, ps -> {
            int n = ps.executeUpdate();
            if (n == 0) {
                throw new DataAccessException("0 rows inserted.");
            }
            if (n > 1) {
                throw new DataAccessException("Multiple rows inserted.");
            }
            try (ResultSet keys = ps.getGeneratedKeys();){
                if (keys.next()) {
                    Number number = (Number)keys.getObject(1);
                    return number;
                }
            }
            throw new DataAccessException("Should not reach here.");
        });
    }

    public int update(String sql, Object ... args) throws DataAccessException {
        return this.execute(this.preparedStatementCreator(sql, args), ps -> ps.executeUpdate());
    }

    public <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action) {
        return (T)this.execute(con -> {
            try (PreparedStatement ps = psc.createPreparedStatement(con);){
                Object t = action.doInPreparedStatement(ps);
                return t;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(ConnectionCallback<T> action) throws DataAccessException {
        Connection current = TransactionalUtils.getCurrentConnection();
        if (current != null) {
            try {
                return action.doInConnection(current);
            }
            catch (SQLException e) {
                throw new DataAccessException(e);
            }
        }
        try (Connection newConn = this.dataSource.getConnection();){
            boolean autoCommit = newConn.getAutoCommit();
            if (!autoCommit) {
                newConn.setAutoCommit(true);
            }
            T result = action.doInConnection(newConn);
            if (!autoCommit) {
                newConn.setAutoCommit(false);
            }
            T t = result;
            return t;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private PreparedStatementCreator preparedStatementCreator(String sql, Object ... args) {
        return con -> {
            PreparedStatement ps = con.prepareStatement(sql);
            this.bindArgs(ps, args);
            return ps;
        };
    }

    private void bindArgs(PreparedStatement ps, Object ... args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            ps.setObject(i + 1, args[i]);
        }
    }
}

