/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.summer.jdbc.tx;

import com.itranswarp.summer.exception.TransactionException;
import com.itranswarp.summer.jdbc.tx.PlatformTransactionManager;
import com.itranswarp.summer.jdbc.tx.TransactionStatus;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceTransactionManager
implements PlatformTransactionManager,
InvocationHandler {
    static final ThreadLocal<TransactionStatus> transactionStatus = new ThreadLocal();
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    final DataSource dataSource;

    public DataSourceTransactionManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Loose catch block
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        TransactionStatus ts = transactionStatus.get();
        if (ts == null) {
            try (Connection connection = this.dataSource.getConnection();){
                boolean autoCommit = connection.getAutoCommit();
                if (autoCommit) {
                    connection.setAutoCommit(false);
                }
                try {
                    transactionStatus.set(new TransactionStatus(connection));
                    Object r = method.invoke(proxy, args);
                    connection.commit();
                    Object object = r;
                    return object;
                }
                catch (InvocationTargetException e) {
                    this.logger.warn("will rollback transaction for caused exception: {}", (Object)(e.getCause() == null ? "null" : e.getCause().getClass().getName()));
                    TransactionException te = new TransactionException(e.getCause());
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sqle) {
                        te.addSuppressed(sqle);
                    }
                    throw te;
                }
                finally {
                    transactionStatus.remove();
                    if (autoCommit) {
                        connection.setAutoCommit(true);
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        return method.invoke(proxy, args);
    }
}

