/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ThreadLocalContext {
    private static ThreadLocal<Map<String, Object>> context = new ThreadLocal();
    private static final String _ID = "_thread_id_";
    public static final String CURRENT_USER_KEY = "_ctx_current_user_";
    public static final String TENANT_ID_KEY = "_ctx_tenantId_";

    public static void set(String key, Object value) {
        if (value == null) {
            return;
        }
        ThreadLocalContext.getContextMap().put(key, value);
    }

    public static String getStringValue(String key) {
        if (context.get() == null) {
            return null;
        }
        return Objects.toString(context.get().get(key), null);
    }

    public static boolean exists(String key) {
        if (context.get() == null) {
            return false;
        }
        return context.get().containsKey(key);
    }

    public static <T> T get(String key) {
        if (context.get() == null) {
            return null;
        }
        return (T)context.get().get(key);
    }

    public static void remove(String ... keys) {
        if (context.get() == null) {
            return;
        }
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            context.get().remove(key);
            ++n2;
        }
    }

    public static boolean isEmpty() {
        return context.get() == null || context.get().isEmpty();
    }

    public static boolean isExpired() {
        if (ThreadLocalContext.isEmpty()) {
            return false;
        }
        String threadId = ThreadLocalContext.getStringValue(_ID);
        if (threadId == null) {
            return false;
        }
        String id = ThreadLocalContext.buildThreadId();
        return !StringUtils.equals((CharSequence)threadId, (CharSequence)id);
    }

    public static String getId() {
        return ThreadLocalContext.getStringValue(_ID);
    }

    public static void unset() {
        if (context.get() != null) {
            context.remove();
        }
    }

    private static Map<String, Object> getContextMap() {
        if (context.get() == null) {
            context.set(new HashMap());
            String id = ThreadLocalContext.buildThreadId();
            ThreadLocalContext.set(_ID, id);
        }
        return context.get();
    }

    private static String buildThreadId() {
        return Thread.currentThread().getName() + Thread.currentThread().getId();
    }
}

