/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTimeConvertDeserializer
extends JsonDeserializer<Date> {
    private static String pattern = "yyyy-MM-dd HH:mm:ss";

    public Date deserialize(JsonParser jsonParser, DeserializationContext dc) throws JsonProcessingException {
        Date date = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        try {
            String val = jsonParser.getText();
            date = dateFormat.parse(val);
        }
        catch (IOException | ParseException pex) {
            throw new RuntimeException("json\u8f6c\u6362Date\u5f02\u5e38\uff0c\u683c\u5f0f\uff1a" + pattern);
        }
        return date;
    }
}

