/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.model;

import com.jeesuite.common.util.SimpleCryptUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AuthUser {
    private static final String CONTACT_CHAR = "#";
    private static final String PLACEHOLDER_CHAR = "{-}";
    private String id;
    private String name;
    private String platform;
    private String userType;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String toEncodeString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.name)).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.platform)).append(CONTACT_CHAR);
        builder.append(AuthUser.trimToPlaceHolder(this.userType)).append(CONTACT_CHAR);
        return SimpleCryptUtils.encrypt(builder.toString());
    }

    public static AuthUser decode(String encodeString) {
        if (StringUtils.isBlank((CharSequence)encodeString)) {
            return null;
        }
        encodeString = SimpleCryptUtils.decrypt(encodeString);
        String[] splits = encodeString.split(CONTACT_CHAR);
        AuthUser user = new AuthUser();
        user.setId(AuthUser.placeHolderToNull(splits[0]));
        user.setName(AuthUser.placeHolderToNull(splits[1]));
        user.setPlatform(AuthUser.placeHolderToNull(splits[2]));
        user.setUserType(AuthUser.placeHolderToNull(splits[3]));
        return user;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    private static String trimToPlaceHolder(String value) {
        return (value = StringUtils.trimToNull((String)value)) == null ? PLACEHOLDER_CHAR : value;
    }

    private static String placeHolderToNull(String value) {
        return PLACEHOLDER_CHAR.equals(value) ? null : value;
    }
}

