/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.serializer;

import com.jeesuite.common.serializer.Serializer;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FSTSerializer
implements Serializer {
    @Override
    public String name() {
        return "fst";
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = null;
        FSTObjectOutput fout = null;
        try {
            out = new ByteArrayOutputStream();
            fout = new FSTObjectOutput((OutputStream)out);
            fout.writeObject(obj);
            fout.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        FSTObjectInput in = null;
        try {
            in = new FSTObjectInput((InputStream)new ByteArrayInputStream(bytes));
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

