/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.serializer;

import com.jeesuite.common.serializer.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JavaSerializer
implements Serializer {
    @Override
    public String name() {
        return "java";
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Object deserialize(byte[] bits) throws IOException {
        if (bits == null || bits.length == 0) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bits);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

