/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import com.jeesuite.common.util.DateUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class BeanUtils {
    private static final String CLASS_PROP_NAME = "class";
    private static Map<String, Map<String, PropertyDescriptor>> cache = new ConcurrentHashMap<String, Map<String, PropertyDescriptor>>();
    private static Map<String, List<String>> fieldCache = new HashMap<String, List<String>>();

    public static <T> T copy(Object src, T dest, boolean setDefaultValForNull) throws BeanConverterException {
        if (src == null) {
            return null;
        }
        try {
            Class<?> destClass = dest.getClass();
            Map<String, PropertyDescriptor> srcDescriptors = BeanUtils.getCachePropertyDescriptors(src.getClass());
            Map<String, PropertyDescriptor> destDescriptors = BeanUtils.getCachePropertyDescriptors(destClass);
            Set<String> keys = destDescriptors.keySet();
            for (String key : keys) {
                boolean matched;
                PropertyDescriptor srcDescriptor = srcDescriptors.get(key);
                if (srcDescriptor == null) continue;
                PropertyDescriptor destDescriptor = destDescriptors.get(key);
                Object value = srcDescriptor.getReadMethod().invoke(src, new Object[0]);
                Class<?> propertyType = destDescriptor.getPropertyType();
                Method writeMethod = destDescriptor.getWriteMethod();
                if (writeMethod == null) {
                    String name = destDescriptor.getName();
                    try {
                        writeMethod = destClass.getMethod("set" + name.substring(0, 1).toUpperCase() + name.substring(1), destDescriptor.getPropertyType());
                        destDescriptor.setWriteMethod(writeMethod);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (writeMethod == null) continue;
                boolean bl = matched = propertyType == srcDescriptor.getPropertyType();
                if (!matched && (value != null || setDefaultValForNull)) {
                    value = BeanUtils.isSimpleDataType(srcDescriptor.getPropertyType()) ? BeanUtils.toValue(srcDescriptor.getPropertyType(), value, propertyType) : BeanUtils.copy(value, propertyType);
                }
                if (value == null && setDefaultValForNull) {
                    if (destDescriptor.getPropertyType() == Long.class || destDescriptor.getPropertyType() == Integer.class || destDescriptor.getPropertyType() == Short.class || destDescriptor.getPropertyType() == Double.class || destDescriptor.getPropertyType() == Float.class) {
                        value = 0;
                    } else if (destDescriptor.getPropertyType() == String.class) {
                        value = "";
                    } else if (destDescriptor.getPropertyType() == BigDecimal.class) {
                        value = BigDecimal.ZERO;
                    }
                }
                if (value == null) continue;
                writeMethod.invoke(dest, value);
            }
            return dest;
        }
        catch (Exception e) {
            throw new BeanConverterException(e);
        }
    }

    public static <T> T copy(Object src, T dest) throws BeanConverterException {
        return BeanUtils.copy(src, dest, false);
    }

    public static <T> List<T> copy(List<?> srcs, Class<T> destClass, boolean setDefaultValForNull) {
        if (srcs == null) {
            return new ArrayList();
        }
        ArrayList<T> dests = new ArrayList<T>(srcs.size());
        for (Object src : srcs) {
            dests.add(BeanUtils.copy(src, destClass, setDefaultValForNull));
        }
        return dests;
    }

    public static <T> List<T> copy(List<?> srcs, Class<T> destClass) {
        return BeanUtils.copy(srcs, destClass, false);
    }

    public static <T> T copy(Object src, Class<T> destClass, boolean setDefaultValForNull) throws BeanConverterException {
        if (src == null) {
            return null;
        }
        try {
            T dest = destClass.newInstance();
            BeanUtils.copy(src, dest, setDefaultValForNull);
            return dest;
        }
        catch (Exception e) {
            throw new BeanConverterException(e);
        }
    }

    public static <T> T copy(Object src, Class<T> destClass) throws BeanConverterException {
        return BeanUtils.copy(src, destClass, false);
    }

    public static void zeroWrapPropertiesToNull(Object bean, String ... excludeFields) throws BeanConverterException {
        try {
            Map<String, PropertyDescriptor> srcDescriptors = BeanUtils.getCachePropertyDescriptors(bean.getClass());
            Set<String> keys = srcDescriptors.keySet();
            List<String> excludeFieldsList = null;
            if (excludeFields != null && excludeFields.length > 0 && StringUtils.isNotBlank((CharSequence)excludeFields[0])) {
                excludeFieldsList = Arrays.asList(excludeFields);
            }
            for (String key : keys) {
                boolean isWrapType;
                PropertyDescriptor srcDescriptor = srcDescriptors.get(key);
                if (srcDescriptor == null || excludeFieldsList != null && excludeFieldsList.contains(key)) continue;
                Object value = srcDescriptor.getReadMethod().invoke(bean, new Object[0]);
                boolean bl = isWrapType = srcDescriptor.getPropertyType() == Long.class || srcDescriptor.getPropertyType() == Integer.class || srcDescriptor.getPropertyType() == Short.class || srcDescriptor.getPropertyType() == Double.class || srcDescriptor.getPropertyType() == Float.class;
                if (!isWrapType || value == null || Integer.parseInt(value.toString()) != 0) continue;
                value = null;
                Method writeMethod = srcDescriptor.getWriteMethod();
                if (writeMethod == null) continue;
                writeMethod.invoke(bean, value);
            }
        }
        catch (Exception e) {
            throw new BeanConverterException(e);
        }
    }

    private static Object toValue(Class<?> srcpropertyType, Object value, Class<?> propertyType) {
        if (propertyType == BigDecimal.class) {
            value = value == null ? BigDecimal.ZERO : new BigDecimal(value.toString());
        } else if (propertyType == Byte.TYPE || propertyType == Byte.class) {
            value = value == null ? Byte.valueOf("0") : Byte.valueOf(value.toString());
        } else if (propertyType == Short.TYPE || propertyType == Short.class) {
            value = value == null ? Short.valueOf("0") : Short.valueOf(value.toString());
        } else if (propertyType == Integer.TYPE || propertyType == Integer.class) {
            value = srcpropertyType == Boolean.TYPE || srcpropertyType == Boolean.class ? Integer.valueOf(Boolean.parseBoolean(value.toString()) ? 1 : 0) : (value == null ? Integer.valueOf("0") : Integer.valueOf(value.toString()));
        } else if (propertyType == Double.TYPE || propertyType == Double.class) {
            value = value == null ? Double.valueOf("0") : Double.valueOf(value.toString());
        } else if (propertyType == Date.class) {
            if (value != null) {
                if (srcpropertyType == String.class) {
                    value = DateUtils.parseDate(value.toString());
                } else if (srcpropertyType == Long.class || srcpropertyType == Integer.class || srcpropertyType == Long.TYPE || srcpropertyType == Integer.TYPE) {
                    Long val = Long.valueOf(value.toString());
                    value = val != 0L ? new Date(val) : null;
                }
            }
        } else if (propertyType == String.class && srcpropertyType != String.class) {
            if (value != null) {
                value = srcpropertyType == Date.class ? DateUtils.format((Date)value, new String[0]) : value.toString();
            }
        } else if ((propertyType == Boolean.TYPE || propertyType == Boolean.class) && value.toString().matches("[0|1]")) {
            value = "1".equals(value.toString());
        }
        return value;
    }

    private static Object stringConvertTo(String value, Class<?> propertyType) {
        Object result = value;
        if (propertyType == BigDecimal.class) {
            result = new BigDecimal(value);
        } else if (propertyType == Byte.TYPE || propertyType == Byte.class) {
            result = Byte.valueOf(value);
        } else if (propertyType == Short.TYPE || propertyType == Short.class) {
            result = Short.valueOf(value.toString());
        } else if (propertyType == Integer.TYPE || propertyType == Integer.class) {
            result = Integer.parseInt(value);
        } else if (propertyType == Double.TYPE || propertyType == Double.class) {
            result = Double.valueOf(value.toString());
        } else if (propertyType == Long.TYPE || propertyType == Long.class) {
            result = Long.valueOf(value.toString());
        } else if (propertyType == Date.class) {
            if (value != null) {
                result = DateUtils.parseDate(value);
            }
        } else if (propertyType == LocalDate.class) {
            if (value != null) {
                result = LocalDate.parse(value);
            }
        } else if (propertyType == Boolean.TYPE || propertyType == Boolean.class) {
            result = Boolean.parseBoolean(value) || "1".equals(value);
        }
        return result;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> clazz) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            T bean = clazz.newInstance();
            Map<String, PropertyDescriptor> descriptors = BeanUtils.getCachePropertyDescriptors(clazz);
            for (PropertyDescriptor descriptor : descriptors.values()) {
                Object object;
                String propertyName = descriptor.getName();
                if (!map.containsKey(propertyName) || (object = map.get(propertyName)) == null) continue;
                if (descriptor.getPropertyType() != object.getClass()) {
                    object = BeanUtils.stringConvertTo(object.toString(), descriptor.getPropertyType());
                }
                descriptor.getWriteMethod().invoke(bean, object);
            }
            return bean;
        }
        catch (Exception e) {
            throw new BeanConverterException(e);
        }
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return BeanUtils.beanToMap(bean, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean recursive) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            Map<String, PropertyDescriptor> descriptors = BeanUtils.getCachePropertyDescriptors(bean.getClass());
            for (PropertyDescriptor descriptor : descriptors.values()) {
                Method readMethod;
                Object result;
                String propertyName = descriptor.getName();
                if (CLASS_PROP_NAME.equalsIgnoreCase(propertyName) || (result = (readMethod = descriptor.getReadMethod()).invoke(bean, new Object[0])) == null) continue;
                if (BeanUtils.isSimpleDataType(result) || result instanceof Iterable) {
                    returnMap.put(propertyName, result);
                    continue;
                }
                if (recursive) {
                    returnMap.put(propertyName, BeanUtils.beanToMap(result, recursive));
                    continue;
                }
                returnMap.put(propertyName, result);
            }
        }
        catch (Exception e) {
            throw new BeanConverterException(e);
        }
        return returnMap;
    }

    public static void copy(Map<String, Object> src, Object dist) {
        try {
            Map<String, PropertyDescriptor> descriptors = BeanUtils.getCachePropertyDescriptors(dist.getClass());
            for (PropertyDescriptor descriptor : descriptors.values()) {
                String propertyName = descriptor.getName();
                if (CLASS_PROP_NAME.equalsIgnoreCase(propertyName) || !src.containsKey(propertyName)) continue;
                Object value = src.get(propertyName);
                value = BeanUtils.toValue(value.getClass(), value, descriptor.getPropertyType());
                descriptor.getWriteMethod().invoke(dist, value);
            }
        }
        catch (Exception e) {
            throw new BeanConverterException(e);
        }
    }

    private static Map<String, PropertyDescriptor> getCachePropertyDescriptors(Class<?> clazz) throws IntrospectionException {
        String canonicalName = clazz.getCanonicalName();
        Map<String, PropertyDescriptor> map = cache.get(canonicalName);
        if (map == null) {
            map = BeanUtils.doCacheClass(clazz, canonicalName);
        }
        return map;
    }

    private static synchronized Map<String, PropertyDescriptor> doCacheClass(Class<?> clazz, String canonicalName) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        if (cache.containsKey(canonicalName)) {
            return cache.get(canonicalName);
        }
        ConcurrentHashMap<String, PropertyDescriptor> map = new ConcurrentHashMap<String, PropertyDescriptor>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        BeanInfo srcBeanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = descriptors = srcBeanInfo.getPropertyDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            fieldNames.add(descriptor.getName());
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            String name = descriptor.getName();
            if (readMethod == null) {
                try {
                    readMethod = clazz.getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
                    descriptor.setReadMethod(readMethod);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (writeMethod == null) {
                try {
                    writeMethod = clazz.getMethod("set" + name.substring(0, 1).toUpperCase() + name.substring(1), descriptor.getPropertyType());
                    descriptor.setWriteMethod(writeMethod);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (readMethod != null && writeMethod != null) {
                map.put(descriptor.getName(), descriptor);
            }
            ++n2;
        }
        cache.put(canonicalName, map);
        fieldCache.put(canonicalName, fieldNames);
        return map;
    }

    public static boolean isSimpleDataType(Object o) {
        return BeanUtils.isSimpleDataType(o.getClass());
    }

    public static boolean isSimpleDataType(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class) || clazz.equals(Boolean.class) || clazz.equals(Date.class);
    }

    public static class BeanConverterException
    extends RuntimeException {
        private static final long serialVersionUID = 152873897614690397L;

        public BeanConverterException(Throwable cause) {
            super(cause);
        }
    }
}

