/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import com.jeesuite.common.util.DateUtils;
import com.jeesuite.common.util.IdCardFormatVerifyHelper;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FormatValidateUtils {
    public static final String EMAIL = "^\\w+((-|\\.)\\w+)*@\\w+(\\.[a-zA-Z]{2,3})+$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^\\w+((-|\\.)\\w+)*@\\w+(\\.[a-zA-Z]{2,3})+$");
    public static final String PHONE = "(^(\\d{2,4}[-_\uff0d\u2014]?)?\\d{3,8}([-_\uff0d\u2014]?\\d{3,8})?([-_\uff0d\u2014]?\\d{1,7})?$)|(^0?1[35]\\d{9}$)";
    private static final Pattern PHONE_PATTERN = Pattern.compile("(^(\\d{2,4}[-_\uff0d\u2014]?)?\\d{3,8}([-_\uff0d\u2014]?\\d{3,8})?([-_\uff0d\u2014]?\\d{1,7})?$)|(^0?1[35]\\d{9}$)");
    public static final String MOBILE = "^(1(3|5|7|8)[0-9])\\d{8}$";
    private static final Pattern MOBILE_PATTERN = Pattern.compile("^(1(3|5|7|8)[0-9])\\d{8}$");
    public static final String INTEGER = "^-?(([1-9]\\d*$)|0)";
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^-?(([1-9]\\d*$)|0)");
    public static final String INTEGER_NEGATIVE = "^[1-9]\\d*|0$";
    private static final Pattern INTEGER_NEGATIVE_PATTERN = Pattern.compile("^[1-9]\\d*|0$");
    public static final String INTEGER_POSITIVE = "^-[1-9]\\d*|0$";
    private static final Pattern INTEGER_POSITIVE_PATTERN = Pattern.compile("^-[1-9]\\d*|0$");
    public static final String DOUBLE = "^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$";
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$");
    public static final String DOUBLE_NEGATIVE = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0$";
    private static final Pattern DOUBLE_NEGATIVE_PATTERN = Pattern.compile("^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0$");
    public static final String DOUBLE_POSITIVE = "^(-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*))|0?\\.0+|0$";
    private static final Pattern DOUBLE_POSITIVE_PATTERN = Pattern.compile("^(-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*))|0?\\.0+|0$");
    public static final String AGE = "^(?:[1-9][0-9]?|1[01][0-9]|120)$";
    private static final Pattern AGE_PATTERN = Pattern.compile("^(?:[1-9][0-9]?|1[01][0-9]|120)$");
    public static final String ZIP_CODE = "[0-9]\\d{5}(?!\\d)";
    private static final Pattern ZIP_CODE_PATTERN = Pattern.compile("[0-9]\\d{5}(?!\\d)");
    public static final String STR_ENG = "^[A-Za-z]+$";
    private static final Pattern STR_ENG_PATTERN = Pattern.compile("^[A-Za-z]+$");
    public static final String URL = "^(http|www|ftp|)?(://)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*((:\\d+)?)(/(\\w+(-\\w+)*))*(\\.?(\\w)*)(\\?)?(((\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*(\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*)*(\\w*)*)$";
    private static final Pattern URL_PATTERN = Pattern.compile("^(http|www|ftp|)?(://)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*((:\\d+)?)(/(\\w+(-\\w+)*))*(\\.?(\\w)*)(\\?)?(((\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*(\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*)*(\\w*)*)$");

    public static boolean isEmail(String str) {
        return EMAIL_PATTERN.matcher(str).matches();
    }

    public static boolean isPhone(String str) {
        return PHONE_PATTERN.matcher(str).matches();
    }

    public static boolean isMobile(String str) {
        return MOBILE_PATTERN.matcher(str).matches();
    }

    public static boolean isUrl(String str) {
        return URL_PATTERN.matcher(str).matches();
    }

    public static boolean isInteger(String str) {
        return INTEGER_PATTERN.matcher(str).matches();
    }

    public static boolean isNegativeInteger(String str) {
        return INTEGER_NEGATIVE_PATTERN.matcher(str).matches();
    }

    public static boolean isPositiveInteger(String str) {
        return INTEGER_POSITIVE_PATTERN.matcher(str).matches();
    }

    public static boolean isDouble(String str) {
        return DOUBLE_PATTERN.matcher(str).matches();
    }

    public static boolean isNegativeDouble(String str) {
        return DOUBLE_NEGATIVE_PATTERN.matcher(str).matches();
    }

    public static boolean isPositiveDouble(String str) {
        return DOUBLE_POSITIVE_PATTERN.matcher(str).matches();
    }

    public static boolean isDate(String str) {
        try {
            DateUtils.parseDate(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAge(String str) {
        return AGE_PATTERN.matcher(str).matches();
    }

    public static boolean isIdCard(String str) {
        return IdCardFormatVerifyHelper.verifyFormat(str);
    }

    public static boolean isZipCode(String str) {
        return ZIP_CODE_PATTERN.matcher(str).matches();
    }

    public static boolean isEnglish(String str) {
        return STR_ENG_PATTERN.matcher(str).matches();
    }

    public static boolean isNumber(String str) {
        return StringUtils.isNumeric((CharSequence)str);
    }

    public static void main(String[] args) {
        System.out.println(FormatValidateUtils.isMobile("17012341234"));
        System.out.println(FormatValidateUtils.isEmail("jia-ng.s_ky@qqq1111111111.com.cn"));
        System.out.println(FormatValidateUtils.isEmail("jian_g-sk&y@qq.com"));
    }
}

