/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import com.jeesuite.common.util.ResourceUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JDBCUtils {
    public static String driverClass = ResourceUtils.getAndValidateProperty("jdbc.driverClass");
    public static String url = ResourceUtils.getAndValidateProperty("jdbc.url");
    public static String userName = ResourceUtils.getAndValidateProperty("jdbc.userName");
    public static String password = ResourceUtils.getAndValidateProperty("jdbc.password");

    static {
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private JDBCUtils() {
    }

    public static Connection getconnnection() {
        Connection con = null;
        try {
            con = DriverManager.getConnection(url, userName, password);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return con;
    }

    public static void close(ResultSet rs, Statement st, Connection con) {
        try {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void close(ResultSet rs) {
        Statement st = null;
        Connection con = null;
        try {
            try {
                if (rs != null) {
                    st = rs.getStatement();
                    rs.close();
                }
            }
            finally {
                try {
                    if (st != null) {
                        con = st.getConnection();
                        st.close();
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void close(Statement st, Connection con) {
        try {
            try {
                if (st != null) {
                    st.close();
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static int update(String sql, Object ... args) {
        int result = 0;
        Connection con = JDBCUtils.getconnnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = con.prepareStatement(sql);
                if (args != null) {
                    int i = 0;
                    while (i < args.length) {
                        ps.setObject(i + 1, args[i]);
                        ++i;
                    }
                }
                result = ps.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
                JDBCUtils.close(ps, con);
            }
        }
        finally {
            JDBCUtils.close(ps, con);
        }
        return result;
    }

    @Deprecated
    public static ResultSet query(String sql, Object ... args) {
        ResultSet result = null;
        Connection con = JDBCUtils.getconnnection();
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    ps.setObject(i + 1, args[i]);
                    ++i;
                }
            }
            result = ps.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map<String, Object> queryForMap(String sql, Object ... args) {
        Map<String, Object> result = new HashMap<String, Object>();
        List<Map<String, Object>> list = JDBCUtils.queryForList(sql, args);
        if (list.size() > 0) {
            result = list.get(0);
        }
        return result;
    }

    public static <T> T queryForObject(String sql, Class<T> clz, Object ... args) {
        T result = null;
        List<T> list = JDBCUtils.queryForList(sql, clz, args);
        if (list.size() > 0) {
            result = list.get(0);
        }
        return result;
    }

    public static List<Map<String, Object>> queryForList(String sql, Object ... args) {
        ArrayList<Map<String, Object>> result;
        block9: {
            result = new ArrayList<Map<String, Object>>();
            Connection con = null;
            ResultSet rs = null;
            PreparedStatement ps = null;
            try {
                try {
                    con = JDBCUtils.getconnnection();
                    ps = con.prepareStatement(sql);
                    if (args != null) {
                        int i = 0;
                        while (i < args.length) {
                            ps.setObject(i + 1, args[i]);
                            ++i;
                        }
                    }
                    rs = ps.executeQuery();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    while (rs.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        int i = 1;
                        while (i <= columnCount) {
                            map.put(rsmd.getColumnLabel(i), rs.getObject(i));
                            ++i;
                        }
                        result.add(map);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JDBCUtils.close(rs, ps, con);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs, ps, con);
                throw throwable;
            }
            JDBCUtils.close(rs, ps, con);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static <T> List<T> queryForList(String sql, Class<T> clz, Object ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

