/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;

public class NetworkUtils {
    public static boolean ping(String host, int timeoutMilliseconds) {
        try {
            InetAddress address = InetAddress.getByName(host);
            return address.isReachable(timeoutMilliseconds);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean telnet(String hostAndPort, int timeoutMilliseconds) {
        String[] parts = StringUtils.splitByWholeSeparator((String)StringUtils.splitByWholeSeparator((String)hostAndPort, (String)",")[0], (String)":");
        if (parts.length != 2 || !StringUtils.isNumeric((CharSequence)parts[1])) {
            throw new IllegalArgumentException("Argument error, format as [127.0.0.1:3306]");
        }
        return NetworkUtils.telnet(parts[0], Integer.parseInt(parts[1]), timeoutMilliseconds);
    }

    /*
     * Loose catch block
     */
    public static boolean telnet(String host, int port, int timeoutMilliseconds) {
        Socket server = null;
        server = new Socket();
        InetSocketAddress address = new InetSocketAddress(host, port);
        if (address.isUnresolved()) {
            System.err.println("Couldn't resolve server [" + host + "] as DNS resolution failed");
        }
        server.connect(address, timeoutMilliseconds);
        try {
            server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
        catch (Exception e) {
            try {
                server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
            catch (Throwable throwable) {
                try {
                    server.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static boolean isPortFree(int port) {
        try {
            Socket socket = new Socket("localhost", port);
            socket.close();
            return false;
        }
        catch (ConnectException e) {
            return true;
        }
        catch (SocketException e) {
            if (e.getMessage().equals("Connection reset by peer")) {
                return true;
            }
            throw new RuntimeException(e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

