/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;

public final class ResourceUtils {
    public static final String NULL_VALUE_PLACEHOLDER = "_NULL_PLACEHOLDER_";
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    private static String withProfileKeyFile = null;
    private static String profileFileBaseName = null;
    private static String activeProfileFile = null;
    private static boolean inited;
    private static final Properties allProperties;

    static {
        allProperties = new Properties();
    }

    private static synchronized void load() {
        if (inited) {
            return;
        }
        try {
            String extPropertyDir;
            URL url = Thread.currentThread().getContextClassLoader().getResource("");
            System.setProperty("framework.website", "www.jeesuite.com");
            if (url == null) {
                url = ResourceUtils.class.getResource("");
            }
            HashMap<String, List<String>> allFileMap = new HashMap<String, List<String>>();
            if (url != null) {
                if (url.getProtocol().equals("file")) {
                    System.out.println(">>loadPropertiesFromFile,origin:" + url.getPath());
                    File parent = new File(url.getPath());
                    if (!parent.exists()) {
                        System.err.println(">>loadPropertiesFromFile_error,dir not found");
                    } else {
                        ResourceUtils.loadPropertiesFromFile(parent, allFileMap);
                        Set fileExts = allFileMap.keySet();
                        for (String string : fileExts) {
                            ResourceUtils.parseConfigSortFiles((List)allFileMap.get(string), string, null);
                        }
                    }
                } else if (url.getProtocol().equals("jar")) {
                    ResourceUtils.loadPropertiesFromJarFile(url, allFileMap);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(extPropertyDir = System.getProperty("ext.config.dir")))) {
                System.out.println(">>load from extPropertyDir:" + extPropertyDir);
                File file = new File(extPropertyDir);
                if (file.exists()) {
                    ResourceUtils.loadPropertiesFromFile(file, allFileMap);
                }
            }
            ArrayList<Object> keys = new ArrayList<Object>(allProperties.keySet());
            for (Object e : keys) {
                String value;
                if (e == null || allProperties.getProperty(e.toString()) == null || !allProperties.getProperty(e.toString()).contains(PLACEHOLDER_PREFIX) || !StringUtils.isNotBlank((CharSequence)(value = ResourceUtils.replaceRefValue(allProperties.getProperty(e.toString()))))) continue;
                allProperties.setProperty(e.toString(), value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        inited = true;
    }

    private static void loadPropertiesFromJarFile(URL url, Map<String, List<String>> allFileMap) throws UnsupportedEncodingException, IOException {
        System.out.println(">>loadPropertiesFromJarFile,origin:" + url.toString());
        String jarFilePath = url.getFile();
        if (jarFilePath.contains("war!")) {
            jarFilePath = String.valueOf(StringUtils.splitByWholeSeparator((String)jarFilePath, (String)"war!")[0]) + "war";
        } else if (jarFilePath.contains("jar!")) {
            jarFilePath = String.valueOf(StringUtils.splitByWholeSeparator((String)jarFilePath, (String)"jar!")[0]) + "jar";
        }
        jarFilePath = jarFilePath.substring("file:".length());
        jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
        System.out.println(">>loadPropertiesFromJarFile,real:" + jarFilePath);
        JarFile jarFile = new JarFile(jarFilePath);
        String fileExt = null;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".properties") && !entry.getName().endsWith(".yml") && !entry.getName().endsWith(".yaml") || entry.getName().contains("i18n") || entry.getName().endsWith("pom.properties")) continue;
            fileExt = entry.getName().substring(entry.getName().lastIndexOf("."));
            if (!allFileMap.containsKey(fileExt)) {
                allFileMap.put(fileExt, new ArrayList());
            }
            allFileMap.get(fileExt).add(entry.getName());
        }
        Set<String> fileExts = allFileMap.keySet();
        for (String key : fileExts) {
            ResourceUtils.parseConfigSortFiles(allFileMap.get(key), key, jarFile);
        }
        jarFile.close();
    }

    private static void loadPropertiesFromFile(File parent, Map<String, List<String>> allFileMap) throws FileNotFoundException, IOException {
        File[] files = parent.listFiles();
        if (files == null) {
            return;
        }
        String fileExt = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                ResourceUtils.loadPropertiesFromFile(file, allFileMap);
            } else {
                String path = file.getPath();
                if ((path.endsWith(".properties") || path.endsWith(".yaml") || path.endsWith(".yml")) && !path.contains("i18n") && !path.endsWith("pom.properties")) {
                    fileExt = path.substring(path.lastIndexOf("."));
                    if (!allFileMap.containsKey(fileExt)) {
                        allFileMap.put(fileExt, new ArrayList());
                    }
                    allFileMap.get(fileExt).add(path);
                }
            }
            ++n2;
        }
    }

    private static void parseConfigSortFiles(List<String> fileList, String fileExt, JarFile jarFile) throws IOException, FileNotFoundException {
        if (fileList.size() == 1) {
            Properties p = ResourceUtils.parseToProperties(fileList.get(0), jarFile);
            allProperties.putAll((Map<?, ?>)p);
            System.out.println(">>load properties from file:" + fileList.get(0));
        } else if (fileList.size() > 1) {
            ResourceUtils.sortFileNames(fileList, fileExt);
            LinkedHashMap<String, Properties> filePropMap = new LinkedHashMap<String, Properties>(fileList.size());
            for (String file : fileList) {
                Properties p = ResourceUtils.parseToProperties(file, jarFile);
                if (withProfileKeyFile == null && p.containsKey("spring.profiles.active")) {
                    withProfileKeyFile = file;
                    profileFileBaseName = String.valueOf(file.replace(fileExt, "")) + "-";
                    String profile = ResourceUtils.replaceRefValue(p.getProperty("spring.profiles.active"));
                    activeProfileFile = String.valueOf(profileFileBaseName) + profile + fileExt;
                    System.out.println(">>activeProfileFile:" + profile);
                }
                filePropMap.put(file, p);
            }
            for (String filePath : filePropMap.keySet()) {
                if (profileFileBaseName != null && !filePath.equals(withProfileKeyFile) && filePath.startsWith(profileFileBaseName) && !filePath.equals(activeProfileFile)) continue;
                allProperties.putAll((Map<?, ?>)((Map)filePropMap.get(filePath)));
                System.out.println(">>load properties from file:" + filePath);
            }
        }
    }

    private static Properties parseToProperties(String path, JarFile jarFile) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        Yaml yaml = null;
        if (path.endsWith(".yaml") || path.endsWith(".yml")) {
            yaml = new Yaml();
        }
        if (jarFile == null) {
            FileReader fileReader = new FileReader(path);
            if (yaml == null) {
                properties.load(fileReader);
            } else {
                Map map = (Map)yaml.load((Reader)fileReader);
                ResourceUtils.parseYamlInnerMap(null, properties, map);
            }
            try {
                fileReader.close();
            }
            catch (Exception map) {}
        } else {
            InputStream inputStream = jarFile.getInputStream(jarFile.getJarEntry(path));
            if (yaml == null) {
                properties.load(inputStream);
            } else {
                Map map = (Map)yaml.load(inputStream);
                ResourceUtils.parseYamlInnerMap(null, properties, map);
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }

    private static void sortFileNames(List<String> files, final String ext) {
        Collections.sort(files, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                o1 = o1.replace(ext, "");
                o2 = o2.replace(ext, "");
                return o1.compareTo(o2);
            }
        });
    }

    public static Properties getAllProperties() {
        return ResourceUtils.getAllProperties(null);
    }

    public static Properties getAllProperties(String prefix) {
        return ResourceUtils.getAllProperties(prefix, true);
    }

    public static Properties getAllProperties(String keyPattern, boolean matchPrefix) {
        if (!inited) {
            ResourceUtils.load();
        }
        Properties properties = new Properties();
        Set<Map.Entry<Object, Object>> entrySet = allProperties.entrySet();
        boolean match = false;
        for (Map.Entry<Object, Object> entry : entrySet) {
            match = StringUtils.isBlank((CharSequence)keyPattern);
            if (!match) {
                match = matchPrefix ? entry.getKey().toString().startsWith(keyPattern) : entry.getKey().toString().matches(keyPattern);
            }
            if (!match) continue;
            String value = ResourceUtils.replaceRefValue(entry.getValue().toString());
            properties.put(entry.getKey(), value);
        }
        return properties;
    }

    public static String getProperty(String key) {
        return ResourceUtils.getProperty(key, null);
    }

    public static String getAnyProperty(String ... keys) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = ResourceUtils.getProperty(key);
            if (value != null) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public static String getAndValidateProperty(String key) {
        String value = ResourceUtils.getProperty(key, null);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(String.format("Property for key:%s not exists", key));
        }
        return value;
    }

    public static String getProperty(String key, String defaultValue) {
        String value;
        if (!inited) {
            ResourceUtils.load();
        }
        if (StringUtils.isNotBlank((CharSequence)(value = System.getProperty(key)))) {
            return value;
        }
        value = System.getenv(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = allProperties.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = ResourceUtils.replaceRefValue(value);
            return value;
        }
        return defaultValue;
    }

    public static int getInt(String key) {
        return ResourceUtils.getInt(key, 0);
    }

    public static int getInt(String key, int defalutValue) {
        String v = ResourceUtils.getProperty(key);
        if (v != null) {
            return Integer.parseInt(v);
        }
        return defalutValue;
    }

    public static long getLong(String key) {
        return ResourceUtils.getLong(key, 0L);
    }

    public static long getLong(String key, long defalutValue) {
        String v = ResourceUtils.getProperty(key);
        if (v != null) {
            return Long.parseLong(v);
        }
        return defalutValue;
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(ResourceUtils.getProperty(key));
    }

    public static boolean getBoolean(String key, boolean defalutValue) {
        return ResourceUtils.containsProperty(key) ? Boolean.parseBoolean(ResourceUtils.getProperty(key)) : defalutValue;
    }

    public static synchronized void merge(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String refValue;
            Object value = entry.getValue();
            if (value == null || !StringUtils.isNotBlank((CharSequence)(refValue = ResourceUtils.replaceRefValue(value.toString())))) continue;
            allProperties.setProperty(entry.getKey().toString(), refValue);
        }
    }

    public static synchronized void merge(Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            String refValue = ResourceUtils.replaceRefValue(properties.get(key).toString());
            if (!StringUtils.isNotBlank((CharSequence)refValue)) continue;
            allProperties.setProperty(key, refValue);
        }
    }

    public static synchronized void add(String key, String value) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)(value = ResourceUtils.replaceRefValue(value)))) {
            allProperties.setProperty(key, value);
        }
    }

    public static boolean containsProperty(String key) {
        if (System.getProperties().containsKey(key)) {
            return true;
        }
        if (System.getenv().containsKey(key)) {
            return true;
        }
        return allProperties.containsKey(key);
    }

    public static String replaceRefValue(Properties properties, String value) {
        if (!value.contains(PLACEHOLDER_PREFIX)) {
            return value;
        }
        String[] segments = value.split("\\$\\{");
        StringBuilder finalValue = new StringBuilder();
        int i = 0;
        while (i < segments.length) {
            String seg = StringUtils.trimToNull((String)segments[i]);
            if (!StringUtils.isBlank((CharSequence)seg)) {
                if (seg.contains(PLACEHOLDER_SUFFIX)) {
                    String refValue;
                    String refKey = seg.substring(0, seg.indexOf(PLACEHOLDER_SUFFIX)).trim();
                    String withBraceString = null;
                    if (seg.contains("{")) {
                        withBraceString = seg.substring(seg.indexOf(PLACEHOLDER_SUFFIX) + 1);
                    }
                    String defaultValue = null;
                    int defaultValSpliterIndex = refKey.indexOf(":");
                    if (defaultValSpliterIndex > 0) {
                        defaultValue = refKey.substring(defaultValSpliterIndex + 1);
                        refKey = refKey.substring(0, defaultValSpliterIndex);
                    }
                    if (StringUtils.isBlank((CharSequence)(refValue = System.getProperty(refKey)))) {
                        refValue = System.getenv(refKey);
                    }
                    if (StringUtils.isBlank((CharSequence)refValue)) {
                        refValue = properties.getProperty(refKey);
                    }
                    if (StringUtils.isBlank((CharSequence)refValue)) {
                        refValue = defaultValue;
                    }
                    if (StringUtils.isBlank((CharSequence)refValue)) {
                        finalValue.append(PLACEHOLDER_PREFIX + refKey + PLACEHOLDER_SUFFIX);
                    } else {
                        finalValue.append(refValue);
                    }
                    if (withBraceString != null) {
                        finalValue.append(withBraceString);
                    } else {
                        String[] segments2 = seg.split("\\}");
                        if (segments2.length == 2) {
                            finalValue.append(segments2[1]);
                        }
                    }
                } else {
                    finalValue.append(seg);
                }
            }
            ++i;
        }
        return finalValue.toString();
    }

    private static String replaceRefValue(String value) {
        return ResourceUtils.replaceRefValue(allProperties, value);
    }

    private static void parseYamlInnerMap(String keyPrefix, Properties result, Map<String, Object> yamlData) {
        for (String key : yamlData.keySet()) {
            String currentKey = keyPrefix == null ? key.toString() : String.valueOf(keyPrefix) + "." + key.toString();
            Object value = yamlData.get(key);
            if (value instanceof Map) {
                ResourceUtils.parseYamlInnerMap(currentKey, result, (Map)value);
                continue;
            }
            result.put(currentKey, value);
        }
    }
}

