/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import com.jeesuite.common.JeesuiteBaseException;
import com.jeesuite.common.crypt.Base64;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RsaSignUtils {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGN_ALGORITHM = "SHA256withRSA";
    private static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final int KEY_SIZE = 1024;
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static PublicKey loadPublicKey(String pubKeyString) {
        byte[] keyBytes = Base64.decode(pubKeyString);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        try {
            KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicKey = factory.generatePublic(x509EncodedKeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            return null;
        }
    }

    public static PrivateKey loadPrivateKey(String privateKeyString) {
        try {
            byte[] privateKeyBytes = Base64.decode(privateKeyString);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return keyFactory.generatePrivate(pkcs8KeySpec);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encrypt(PublicKey key, String plainText) {
        byte[] encodeBytes = RsaSignUtils.encrypt(key, plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeToString(encodeBytes, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encrypt(PublicKey key, byte[] plainBytes) {
        ByteArrayOutputStream out = null;
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, key);
            int inputLen = plainBytes.length;
            if (inputLen <= 117) {
                byte[] byArray2 = cipher.doFinal(plainBytes);
                return byArray2;
            }
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (true) {
                if (inputLen - offSet <= 0) {
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(plainBytes, offSet, 117) : cipher.doFinal(plainBytes, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new JeesuiteBaseException(4003, "\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new JeesuiteBaseException(4003, "\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new JeesuiteBaseException(4003, "\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new JeesuiteBaseException(4003, "\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String decrypt(PrivateKey key, String encodedText) {
        byte[] bytes = Base64.decode(encodedText);
        return RsaSignUtils.decrypt(key, bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decrypt(PrivateKey key, byte[] encodedText) {
        ByteArrayOutputStream out = null;
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, key);
            int inputLen = encodedText.length;
            if (inputLen <= 128) {
                String string2 = new String(cipher.doFinal(encodedText), StandardCharsets.UTF_8);
                return string2;
            }
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (true) {
                if (inputLen - offSet <= 0) {
                    String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
                    return string;
                }
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encodedText, offSet, 128) : cipher.doFinal(encodedText, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new JeesuiteBaseException(4003, "\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new JeesuiteBaseException(4003, "\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new JeesuiteBaseException(4003, "\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new JeesuiteBaseException(4003, "\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String signature(PrivateKey privateKey, String contents) {
        try {
            byte[] data = contents.getBytes(StandardCharsets.UTF_8.name());
            Signature signature = Signature.getInstance(SIGN_ALGORITHM);
            signature.initSign(privateKey);
            signature.update(data);
            return Base64.encodeToString(signature.sign(), false);
        }
        catch (NoSuchAlgorithmException data) {
        }
        catch (InvalidKeyException e) {
            throw new JeesuiteBaseException(4003, "\u79c1\u94a5\u683c\u5f0f\u9519\u8bef");
        }
        catch (SignatureException signatureException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public static boolean verifySignature(String contents, String sign, PublicKey publicKey) {
        try {
            byte[] data = contents.getBytes(StandardCharsets.UTF_8.name());
            byte[] dataSignature = Base64.decode(sign);
            Signature signature = Signature.getInstance(SIGN_ALGORITHM);
            signature.initVerify(publicKey);
            signature.update(data, 0, data.length);
            return signature.verify(dataSignature);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String[] generateKeyPair() {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = Base64.encodeToString(publicKey.getEncoded(), true);
        String privateKeyString = Base64.encodeToString(privateKey.getEncoded(), true);
        return new String[]{publicKeyString, privateKeyString};
    }

    public static void main(String[] args) {
        PublicKey publicKey = RsaSignUtils.loadPublicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDa2AxOvOQwvL1WHzjPPuZqFUkZLxG3dluThj3/leLygtJt3aNeAq8mKNEdAciD8uYfmQ4MrlAhvwvCCcEN9Ka6hkn6pUOzNZNC5P265vNqpU7GwL3yACsXHdRod9yVN3jVMZp5BR6+tLWLG2BEfmgvQD+8NMSwj9Aq2YvH3AdVOwIDAQAB");
        String contents = "appId=60060&data={amount=1000&attach=abc1234&customCompanyId=55108&invoiceSubjectId=10005&invoiceType=PP&notifyUrl=http://192.168.1.94:11841/out/invoiceNotifySuc&outOrderNo=1234&remark=1231234&serviceCompanyId=1000}&method=ayg.invoice.invoiceApply&nonce=a9607bd2b9ff4872a99ea02c67dda8a8&timestamp=2018-07-17 10:47:54&version=1.0";
        String sign = "VY+PJ4IyOnVxVAZ+AODBfH9kXlHY+PJDKxJNwtEIp9XQJio9lMsDdxAPABm59zWuY01vZdc5bRVjwGT1FuFIMzD8mUg3MVfRFNS7zoefQOw/JvNHvCXaTv9YcbKzW+x3/tl3fUn6Z/ytGE7NC20O9f4GNgJhBipsslFDyrBFeso=";
        System.out.println("sign --> " + RsaSignUtils.verifySignature(contents, sign, publicKey));
    }
}

