/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import com.jeesuite.common.JeesuiteBaseException;
import com.jeesuite.common.crypt.DES;
import com.jeesuite.common.util.DigestUtils;
import com.jeesuite.common.util.ResourceUtils;
import com.jeesuite.common.util.SimpleCryptUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class TokenGenerator {
    private static final String LINE_THROUGH = "-";
    private static final int EXPIRE = 180000;

    public static String generate(String ... prefixs) {
        String str = StringUtils.replace((String)UUID.randomUUID().toString(), (String)LINE_THROUGH, (String)"");
        if (prefixs != null && prefixs.length > 0 && StringUtils.isNotBlank((CharSequence)prefixs[0])) {
            return prefixs[0].concat(str);
        }
        return str;
    }

    public static String generateWithSign() {
        return TokenGenerator.generateWithSign(null);
    }

    public static String generateWithSign(String tokenType) {
        Date date = new Date();
        String str = DigestUtils.md5Short(TokenGenerator.generate(new String[0])).concat(String.valueOf(date.getTime()));
        if (tokenType == null) {
            return SimpleCryptUtils.encrypt(str);
        }
        String cryptKey = TokenGenerator.getCryptKey(tokenType, date);
        return DES.encrypt(cryptKey, str).toLowerCase();
    }

    public static void validate(String token, boolean validateExpire) {
        TokenGenerator.validate(null, token, validateExpire);
    }

    public static void validate(String tokenType, String token, boolean validateExpire) {
        long timestamp = 0L;
        Date date = new Date();
        try {
            if (tokenType == null) {
                timestamp = Long.parseLong(SimpleCryptUtils.decrypt(token).substring(6));
            } else {
                String cryptKey = TokenGenerator.getCryptKey(tokenType, date);
                timestamp = Long.parseLong(DES.decrypt(cryptKey, token).substring(6));
            }
        }
        catch (Exception e) {
            throw new JeesuiteBaseException(4005, "token\u683c\u5f0f\u9519\u8bef");
        }
        if (validateExpire && date.getTime() - timestamp > 180000L) {
            throw new JeesuiteBaseException(4005, "token\u5df2\u8fc7\u671f");
        }
    }

    private static String getCryptKey(String tokenType, Date date) {
        String key = "";
        if (StringUtils.isNotBlank((CharSequence)tokenType)) {
            key = ResourceUtils.getAndValidateProperty(String.valueOf(tokenType) + ".cryptKey");
        }
        SimpleDateFormat format = new SimpleDateFormat("ddMMMyy", Locale.ENGLISH);
        key = String.valueOf(key) + format.format(date).toUpperCase();
        key = DigestUtils.md5(key).substring(0, 8);
        return key;
    }

    public static void main(String[] args) {
        System.setProperty("jeesuite.configcenter.cryptKey", "sdf2333333333");
        String generateWithSign = TokenGenerator.generateWithSign("jeesuite.configcenter");
        System.out.println(generateWithSign);
        TokenGenerator.validate("jeesuite.configcenter", generateWithSign, true);
    }
}

