/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ApacheProxyConfig;
import com.oracle.bmc.http.ClientConfigDecorator;
import com.oracle.bmc.util.internal.Validate;
import javax.annotation.Nonnull;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheProxyConfigDecorator
implements ClientConfigDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheProxyConfigDecorator.class);
    private final ApacheProxyConfig proxyConfig;

    public ApacheProxyConfigDecorator(@Nonnull ApacheProxyConfig proxyConfig) {
        if (proxyConfig == null) {
            throw new NullPointerException("proxyConfig is marked non-null but is null");
        }
        this.proxyConfig = proxyConfig;
    }

    @Override
    public void customizeClientConfig(ClientConfig clientConfig) {
        Validate.notNull(clientConfig, "ClientConfig must not be null", new Object[0]);
        ConnectorProvider provider = clientConfig.getConnectorProvider();
        Validate.isInstanceOf(ApacheConnectorProvider.class, provider, String.format("ConnectorProvider of type [%s] is not supported. Expected ApacheConnectorProvider", provider.getClass().getCanonicalName()), new Object[0]);
        if (!this.proxyConfig.isConfiguredAndValid()) {
            LOG.info("Invalid proxy configuration.  Not configuring a proxy.");
            return;
        }
        LOG.debug("ApacheProxyConfig: {}", (Object)this.proxyConfig);
        String proxyUri = this.proxyConfig.getUri();
        LOG.info("Configuring proxy for ApacheConnectorProvider to connect to {}", (Object)proxyUri);
        clientConfig.property("jersey.config.client.proxy.uri", (Object)proxyUri);
        ApacheProxyConfigDecorator.configureAuth(clientConfig, this.proxyConfig);
    }

    private static void configureAuth(ClientConfig clientConfig, ApacheProxyConfig proxyConfig) {
        String username = proxyConfig.getUsername();
        String password = proxyConfig.getPassword();
        if (username == null || password == null) {
            LOG.info("Either username or password is null. Not configuring auth credentials for the proxy");
        } else {
            LOG.info("Configuring auth credentials for the proxy");
            clientConfig.property("jersey.config.client.proxy.username", (Object)username);
            clientConfig.property("jersey.config.client.proxy.password", (Object)password);
        }
    }
}

