/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ApacheConfigurator;
import com.oracle.bmc.http.ApacheConnectorProperties;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.CompositeClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.HasApacheConnectorProperties;
import com.oracle.bmc.http.HasEffectiveClientConfigurator;
import com.oracle.bmc.util.internal.StringUtils;
import java.util.Optional;
import java.util.function.Function;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;

public final class ApacheUtils {
    private static final boolean isExtraStreamLogsEnabled = ApacheUtils.isExtraStreamLogsEnabledViaSystemProperty();

    public static boolean isNonBufferingClientConfigurator(ClientConfigurator clientConfigurator) {
        boolean isNonBufferingApacheClient = false;
        if (clientConfigurator instanceof CompositeClientConfigurator) {
            CompositeClientConfigurator compositeClientConfigurator = (CompositeClientConfigurator)clientConfigurator;
            Optional<ClientConfigurator> optionalEffectiveConfigurator = ApacheUtils.filterOutEffectiveCompositeConfigurator(compositeClientConfigurator, new Class[]{DefaultConfigurator.NonBuffering.class, ApacheConfigurator.NonBuffering.class});
            if (optionalEffectiveConfigurator.isPresent()) {
                ClientConfigurator effectiveClientConfigurator = optionalEffectiveConfigurator.get();
                if (effectiveClientConfigurator instanceof ApacheConfigurator.NonBuffering) {
                    isNonBufferingApacheClient = true;
                } else if (effectiveClientConfigurator instanceof HasEffectiveClientConfigurator) {
                    isNonBufferingApacheClient = ((HasEffectiveClientConfigurator)((Object)effectiveClientConfigurator)).getEffectiveClientConfigurator() instanceof ApacheConfigurator.NonBuffering;
                }
            }
        } else if (clientConfigurator instanceof ApacheConfigurator.NonBuffering) {
            isNonBufferingApacheClient = true;
        }
        return isNonBufferingApacheClient;
    }

    public static ApacheConnectionClosingStrategy getApacheConnectionClosingStrategy(ClientConfigurator clientConfigurator) {
        return ApacheUtils.getApacheConnectionSetting(clientConfigurator, acp -> acp.getConnectionClosingStrategy());
    }

    public static boolean getApacheConnectionExpectContinue(ClientConfigurator clientConfigurator) {
        if (clientConfigurator == null) {
            clientConfigurator = new DefaultConfigurator().getEffectiveClientConfigurator();
        } else if (clientConfigurator instanceof DefaultConfigurator) {
            clientConfigurator = ((DefaultConfigurator)clientConfigurator).getEffectiveClientConfigurator();
        }
        Boolean apacheConnectionSetting = ApacheUtils.getApacheConnectionSetting(clientConfigurator, acp -> acp.isExpectContinue());
        return apacheConnectionSetting == Boolean.TRUE;
    }

    static <T> T getApacheConnectionSetting(ClientConfigurator clientConfigurator, Function<ApacheConnectorProperties, T> settingsExtractor) {
        HasApacheConnectorProperties apacheClientConfigurator;
        T property = null;
        if (clientConfigurator instanceof CompositeClientConfigurator) {
            CompositeClientConfigurator compositeClientConfigurator = (CompositeClientConfigurator)clientConfigurator;
            Optional<ClientConfigurator> optionalEffectiveConfigurator = ApacheUtils.filterOutEffectiveCompositeConfigurator(compositeClientConfigurator, new Class[]{DefaultConfigurator.class, DefaultConfigurator.NonBuffering.class, ApacheConfigurator.NonBuffering.class, ApacheConfigurator.class});
            if (optionalEffectiveConfigurator.isPresent()) {
                HasApacheConnectorProperties innerEffectiveApacheClientConfigurator;
                ClientConfigurator innerEffectiveClientConfigurator;
                ClientConfigurator effectiveClientConfigurator = optionalEffectiveConfigurator.get();
                if (effectiveClientConfigurator instanceof HasApacheConnectorProperties) {
                    HasApacheConnectorProperties effectiveApacheConnectorConfigurator = (HasApacheConnectorProperties)((Object)effectiveClientConfigurator);
                    if (effectiveApacheConnectorConfigurator.getApacheConnectorProperties() != null && effectiveApacheConnectorConfigurator.getApacheConnectorProperties().getConnectionClosingStrategy() != null) {
                        property = settingsExtractor.apply(effectiveApacheConnectorConfigurator.getApacheConnectorProperties());
                    }
                } else if (effectiveClientConfigurator instanceof HasEffectiveClientConfigurator && (innerEffectiveClientConfigurator = ((HasEffectiveClientConfigurator)((Object)effectiveClientConfigurator)).getEffectiveClientConfigurator()) instanceof HasApacheConnectorProperties && (innerEffectiveApacheClientConfigurator = (HasApacheConnectorProperties)((Object)innerEffectiveClientConfigurator)).getApacheConnectorProperties() != null && innerEffectiveApacheClientConfigurator.getApacheConnectorProperties().getConnectionClosingStrategy() != null) {
                    property = settingsExtractor.apply(innerEffectiveApacheClientConfigurator.getApacheConnectorProperties());
                }
            }
        } else if (clientConfigurator instanceof HasApacheConnectorProperties && (apacheClientConfigurator = (HasApacheConnectorProperties)((Object)clientConfigurator)).getApacheConnectorProperties() != null && apacheClientConfigurator.getApacheConnectorProperties().getConnectionClosingStrategy() != null) {
            property = settingsExtractor.apply(apacheClientConfigurator.getApacheConnectorProperties());
        }
        return property;
    }

    private static boolean isExtraStreamLogsEnabledViaSystemProperty() {
        String trimmedValue;
        String streamLogsEnabledString = System.getProperty("oci.javasdk.extra.stream.logs.enabled");
        return streamLogsEnabledString == null || streamLogsEnabledString.isEmpty() || !StringUtils.equalsIgnoreCase("false", trimmedValue = streamLogsEnabledString.trim());
    }

    private static Optional<ClientConfigurator> filterOutEffectiveCompositeConfigurator(CompositeClientConfigurator compositeClientConfigurator, Class[] classesToFilter) {
        return compositeClientConfigurator.getConfigurators().stream().filter(c -> ApacheUtils.filterMethod(c, classesToFilter)).findAny();
    }

    private static boolean filterMethod(Object c, Class[] classesToFilter) {
        boolean result = false;
        for (Class clazz : classesToFilter) {
            result = result || clazz.isInstance(c);
        }
        return result;
    }

    public static boolean isExtraStreamLogsEnabled() {
        return isExtraStreamLogsEnabled;
    }
}

