/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ClientConfigurator;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.glassfish.jersey.logging.LoggingFeature;

public class JerseyLoggingClientConfigurator
implements ClientConfigurator {
    @Nonnull
    private LoggingFeature.Verbosity verbosity;
    @Nonnull
    private String loggingLevel;

    public JerseyLoggingClientConfigurator(@Nonnull LoggingFeature.Verbosity verbosity, @Nonnull String loggingLevel) {
        if (verbosity == null) {
            throw new NullPointerException("verbosity is marked non-null but is null");
        }
        if (loggingLevel == null) {
            throw new NullPointerException("loggingLevel is marked non-null but is null");
        }
        this.verbosity = verbosity;
        this.loggingLevel = loggingLevel;
    }

    public JerseyLoggingClientConfigurator(@Nonnull LoggingFeature.Verbosity verbosity, @Nonnull Level loggingLevel) {
        if (verbosity == null) {
            throw new NullPointerException("verbosity is marked non-null but is null");
        }
        if (loggingLevel == null) {
            throw new NullPointerException("loggingLevel is marked non-null but is null");
        }
        this.verbosity = verbosity;
        this.loggingLevel = loggingLevel.toString();
    }

    @Override
    public void customizeBuilder(ClientBuilder builder) {
    }

    @Override
    public void customizeClient(Client client) {
        client.property("jersey.config.client.logging.verbosity", (Object)this.verbosity);
        client.property("jersey.config.client.logging.logger.level", (Object)this.loggingLevel);
    }
}

