/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.oracle.bmc.http.signing.internal.Algorithm;
import com.oracle.bmc.http.signing.internal.KeyIdType;
import com.oracle.bmc.http.signing.internal.Version;
import com.oracle.bmc.util.internal.Validate;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public enum SignedRequestVersion implements Version
{
    ONE(1, SignedRequestVersion.unmodifiableSetOf(Algorithm.RSAPSS256), SignedRequestVersion.unmodifiableSetOf(KeyIdType.REF), 2048);

    private static final Optional<Version.Error> ABSENT;
    private final int number;
    private final Set<Algorithm> algorithms;
    private final Set<KeyIdType> keyIdTypes;
    private final int minimumKeySize;

    private SignedRequestVersion(int number, Set<Algorithm> algorithms, Set<KeyIdType> keyIdTypes, int minimumKeySize) {
        this.number = number;
        this.algorithms = algorithms;
        this.keyIdTypes = keyIdTypes;
        this.minimumKeySize = minimumKeySize;
    }

    @Override
    public Set<Algorithm> getSupportedAlgorithms() {
        return this.algorithms;
    }

    @Override
    public Set<KeyIdType> getSupportedKeyIdTypes() {
        return this.keyIdTypes;
    }

    @Override
    public int getVersionNumber() {
        return this.number;
    }

    @Override
    public String getVersionName() {
        return String.valueOf(this.getVersionNumber());
    }

    @Override
    public int getMinimumKeySizeInBits() {
        return this.minimumKeySize;
    }

    @Override
    public Optional<Version.Error> validateKeyId(@Nonnull String keyId) {
        Validate.notBlank(keyId, "keyId may not be blank", new Object[0]);
        boolean isKeyIdValid = false;
        for (KeyIdType idType : this.getSupportedKeyIdTypes()) {
            if (!keyId.matches(idType.getPattern())) continue;
            isKeyIdValid = true;
            break;
        }
        return isKeyIdValid ? ABSENT : Optional.of(Version.Error.UNSUPPORTED_KEYID);
    }

    @Override
    public Optional<Version.Error> validateAlgorithm(@Nonnull Algorithm algorithm) {
        Validate.notNull(algorithm, "algorithm must not be null", new Object[0]);
        boolean isAlgorithmValid = this.getSupportedAlgorithms().contains((Object)algorithm);
        return isAlgorithmValid ? ABSENT : Optional.of(Version.Error.UNSUPPORTED_ALGORITHM);
    }

    @Override
    public Optional<Version.Error> validateKeySize(@Nonnull RSAPublicKey publicKey) {
        int keySize = publicKey.getModulus().bitLength();
        if (keySize < this.getMinimumKeySizeInBits()) {
            return Optional.of(Version.Error.KEY_TOO_SMALL);
        }
        return ABSENT;
    }

    public static SignedRequestVersion getLatestVersion() {
        return ONE;
    }

    static Optional<SignedRequestVersion> getVersion(@Nonnull String versionNumber) {
        Validate.notNull(versionNumber, "versionNumber must not be null", new Object[0]);
        try {
            Integer number = Integer.valueOf(versionNumber.trim());
            for (SignedRequestVersion version : SignedRequestVersion.values()) {
                if (version.getVersionNumber() != number.intValue()) continue;
                return Optional.of(version);
            }
            return Optional.empty();
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private static <T> Set<T> unmodifiableSetOf(T item) {
        HashSet<T> set = new HashSet<T>();
        set.add(item);
        return Collections.unmodifiableSet(set);
    }

    static {
        ABSENT = Optional.empty();
    }
}

