/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.naming.event.ServerListChangedEvent;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientManager;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.InitUtils;
import com.alibaba.nacos.client.naming.utils.NamingHttpUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ServerListManager
implements ServerListFactory,
Closeable {
    private final NacosRestTemplate nacosRestTemplate = NamingHttpClientManager.getInstance().getNacosRestTemplate();
    private final long refreshServerListInternal = TimeUnit.SECONDS.toMillis(30L);
    private final String namespace;
    private final AtomicInteger currentIndex = new AtomicInteger();
    private final List<String> serverList = new ArrayList<String>();
    private List<String> serversFromEndpoint = new ArrayList<String>();
    private ScheduledExecutorService refreshServerListExecutor;
    private String endpoint;
    private String nacosDomain;
    private long lastServerListRefreshTime = 0L;

    public ServerListManager(Properties properties) {
        this(properties, null);
    }

    public ServerListManager(Properties properties, String namespace) {
        this.namespace = namespace;
        this.initServerAddr(properties);
        if (!this.serverList.isEmpty()) {
            this.currentIndex.set(new Random().nextInt(this.serverList.size()));
        }
    }

    private void initServerAddr(Properties properties) {
        this.endpoint = InitUtils.initEndpoint(properties);
        if (StringUtils.isNotEmpty((String)this.endpoint)) {
            this.serversFromEndpoint = this.getServerListFromEndpoint();
            this.refreshServerListExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.client.naming.server.list.refresher"));
            this.refreshServerListExecutor.scheduleWithFixedDelay(this::refreshServerListIfNeed, 0L, this.refreshServerListInternal, TimeUnit.MILLISECONDS);
        } else {
            String serverListFromProps = properties.getProperty("serverAddr");
            if (StringUtils.isNotEmpty((String)serverListFromProps)) {
                this.serverList.addAll(Arrays.asList(serverListFromProps.split(",")));
                if (this.serverList.size() == 1) {
                    this.nacosDomain = serverListFromProps;
                }
            }
        }
    }

    private List<String> getServerListFromEndpoint() {
        try {
            String urlString = "http://" + this.endpoint + "/nacos/serverlist";
            Header header = NamingHttpUtil.builderHeader();
            Query query = StringUtils.isNotBlank((String)this.namespace) ? Query.newInstance().addParam("namespace", (Object)this.namespace) : Query.EMPTY;
            HttpRestResult restResult = this.nacosRestTemplate.get(urlString, header, query, String.class);
            if (!restResult.ok()) {
                throw new IOException("Error while requesting: " + urlString + "'. Server returned: " + restResult.getCode());
            }
            String content = (String)restResult.getData();
            ArrayList<String> list = new ArrayList<String>();
            for (String line : IoUtils.readLines((Reader)new StringReader(content))) {
                if (line.trim().isEmpty()) continue;
                list.add(line.trim());
            }
            return list;
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.error("[SERVER-LIST] failed to update server list.", (Throwable)e);
            return null;
        }
    }

    private void refreshServerListIfNeed() {
        try {
            if (!CollectionUtils.isEmpty(this.serverList)) {
                LogUtils.NAMING_LOGGER.debug("server list provided by user: " + this.serverList);
                return;
            }
            if (System.currentTimeMillis() - this.lastServerListRefreshTime < this.refreshServerListInternal) {
                return;
            }
            List<String> list = this.getServerListFromEndpoint();
            if (CollectionUtils.isEmpty(list)) {
                throw new Exception("Can not acquire Nacos list");
            }
            if (null == this.serversFromEndpoint || !CollectionUtils.isEqualCollection(list, this.serversFromEndpoint)) {
                LogUtils.NAMING_LOGGER.info("[SERVER-LIST] server list is updated: " + list);
            }
            this.serversFromEndpoint = list;
            this.lastServerListRefreshTime = System.currentTimeMillis();
            NotifyCenter.publishEvent((Event)new ServerListChangedEvent());
        }
        catch (Throwable e) {
            LogUtils.NAMING_LOGGER.warn("failed to update server list", e);
        }
    }

    public boolean isDomain() {
        return StringUtils.isNotBlank((String)this.nacosDomain);
    }

    public String getNacosDomain() {
        return this.nacosDomain;
    }

    public List<String> getServerList() {
        return this.serverList.isEmpty() ? this.serversFromEndpoint : this.serverList;
    }

    public String genNextServer() {
        int index = this.currentIndex.incrementAndGet() % this.getServerList().size();
        return this.getServerList().get(index);
    }

    public String getCurrentServer() {
        return this.getServerList().get(this.currentIndex.get() % this.getServerList().size());
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        if (null != this.refreshServerListExecutor) {
            ThreadUtils.shutdownThreadPool((ExecutorService)this.refreshServerListExecutor, (Logger)LogUtils.NAMING_LOGGER);
        }
        NamingHttpClientManager.getInstance().shutdown();
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

